% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_missing_symbol.R
\name{modify_missing_symbol}
\alias{modify_missing_symbol}
\title{Modify Missing Substitution}
\usage{
modify_missing_symbol(x, symbol, columns, rows)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
A gtsummary object}

\item{symbol}{(\code{string})\cr
string indicating how missing values are formatted.}

\item{columns}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to add missing symbol.}

\item{rows}{(predicate \code{expression})\cr
Predicate expression to select rows in \code{x$table_body}.
Review \link[=rows_argument]{rows argument details}.}
}
\value{
Updated gtsummary object
}
\description{
Specify how missing values will be represented in the printed table.
By default, a blank space is printed for all \code{NA} values.
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) withAutoprint(\{ # examplesIf}
# Use the abbreivation "Ref." for reference rows instead of the em-dash
lm(marker ~ trt, data = trial) |>
  tbl_regression() |>
  modify_missing_symbol(
    symbol = "Ref.",
    columns = c(estimate, conf.low, conf.high),
    rows = reference_row == TRUE
  )
\dontshow{\}) # examplesIf}
}
