% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_gtsummary_theme.R
\name{set_gtsummary_theme}
\alias{set_gtsummary_theme}
\alias{reset_gtsummary_theme}
\alias{get_gtsummary_theme}
\alias{with_gtsummary_theme}
\alias{check_gtsummary_theme}
\title{Set gtsummary theme}
\usage{
set_gtsummary_theme(x, quiet)

reset_gtsummary_theme()

get_gtsummary_theme()

with_gtsummary_theme(
  x,
  expr,
  env = rlang::caller_env(),
  msg_ignored_elements = NULL
)

check_gtsummary_theme(x)
}
\arguments{
\item{x}{(named \code{list})\cr
A named list defining a gtsummary theme.}

\item{quiet}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{expr}{(\code{expression})\cr
Expression to be evaluated with the theme specified in \verb{x=} loaded}

\item{env}{(\code{environment})\cr
The environment in which to evaluate \verb{expr=}}

\item{msg_ignored_elements}{(\code{string})\cr
Default is \code{NULL} with no message printed. Pass a string
that will be printed with \code{cli::cli_alert_info()}. The \code{"{elements}"}
object contains vector of theme elements that will be overwritten and ignored.}
}
\description{
Functions to \strong{set}, \strong{reset}, \strong{get}, and evaluate \strong{with} gtsummary themes.
\itemize{
\item \code{set_gtsummary_theme()} set a theme
\item \code{reset_gtsummary_theme()} reset themes
\item \code{get_gtsummary_theme()} get a named list with all active theme elements
\item \code{with_gtsummary_theme()} evaluate an expression with a theme temporarily set
\item \code{check_gtsummary_theme()} checks if passed theme is valid
}
}
\section{Details}{

The default formatting and styling throughout the gtsummary package are
taken from the published reporting guidelines of the top four urology
journals: European Urology, The Journal of Urology, Urology and
the British Journal of Urology International. Use this function to change
the default reporting style to match another journal, or your own
personal style.
}

\examples{
# Setting JAMA theme for gtsummary
set_gtsummary_theme(theme_gtsummary_journal("jama"))
# Themes can be combined by including more than one
set_gtsummary_theme(theme_gtsummary_compact())

set_gtsummary_theme_ex1 <-
  trial |>
  tbl_summary(by = trt, include = c(age, grade, trt)) |>
  add_stat_label() |>
  as_gt()

# reset gtsummary theme
reset_gtsummary_theme()
}
\seealso{
\href{https://www.danieldsjoberg.com/gtsummary/articles/themes.html}{Themes vignette}

Available \link[=theme_gtsummary]{gtsummary themes}
}
