% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_scp.R
\name{hcp_scp}
\alias{hcp_scp}
\title{Seminal change point}
\usage{
hcp_scp(sw_size = 30)
}
\arguments{
\item{sw_size}{Sliding window size}
}
\value{
\code{hcp_scp} object
}
\description{
Change-point detection is related to event/trend change detection. Seminal change point detects change points based on deviations of linear regression models adjusted with and without a central observation in each sliding window <10.1145/312129.312190>.
}
\examples{
library(daltoolbox)

# Load change-point example data
data(examples_changepoints)

# Use a simple example
dataset <- examples_changepoints$simple
head(dataset)

# Configure seminal change-point detector
model <- hcp_scp()

# Fit the model
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected change points
print(detection[(detection$event),])

}
\references{
\itemize{
\item Ogasawara, E., Salles, R., Porto, F., Pacitti, E. Event Detection in Time Series. 1st ed.
Cham: Springer Nature Switzerland, 2025. doi:10.1007/978-3-031-75941-3
}
}
