% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmu_pca.R
\name{hmu_pca}
\alias{hmu_pca}
\title{Multivariate anomaly detector using PCA}
\usage{
hmu_pca()
}
\value{
\code{hmu_pca} object.
}
\description{
Projects multivariate observations onto principal components and flags
large reconstruction errors as anomalies. Based on classical PCA.
}
\details{
The series is standardized, PCA is computed, and data are reconstructed from
principal components. The reconstruction error is summarized and thresholded.
}
\examples{
library(daltoolbox)

# Load multivariate example data
data(examples_harbinger)

# Use a multidimensional time series
dataset <- examples_harbinger$multidimensional
head(dataset)

# Configure PCA-based anomaly detector
model <- hmu_pca()

# Fit the model (example uses first two columns)
model <- fit(model, dataset[,1:2])

# Run detection
detection <- detect(model, dataset[,1:2])

# Show detected anomalies
print(detection[(detection$event),])

# Evaluate detections
evaluation <- evaluate(model, detection$event, dataset$event)
print(evaluation$confMatrix)

}
\references{
\itemize{
\item Jolliffe IT (2002). Principal Component Analysis. Springer.
}
}
