/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5Pmodule.h" 

#include "H5private.h"   
#include "H5ACprivate.h" 
#include "H5Eprivate.h"  
#include "H5Fprivate.h"  
#include "H5FDprivate.h" 
#include "H5Iprivate.h"  
#include "H5MMprivate.h" 
#include "H5Ppkg.h"      
#include "H5PBprivate.h" 
#include "H5VLprivate.h" 
#include "H5VMprivate.h" 

#include "H5FDsec2.h" 
#include "H5FDcore.h"
#include "H5FDlog.h"
#include "H5FDfamily.h"
#include "H5FDmulti.h"
#include "H5FDstdio.h" 
#include "H5FDsplitter.h"
#ifdef H5_HAVE_PARALLEL
#include "H5FDmpio.h"
#endif
#ifdef H5_HAVE_DIRECT
#include "H5FDdirect.h"
#endif
#ifdef H5_HAVE_MIRROR_VFD
#include "H5FDmirror.h"
#endif
#ifdef H5_HAVE_LIBHDFS
#include "H5FDhdfs.h"
#endif
#ifdef H5_HAVE_ROS3_VFD
#include "H5FDros3.h"
#endif
#ifdef H5_HAVE_SUBFILING_VFD
#include "H5FDsubfiling.h"
#endif
#ifdef H5_HAVE_WINDOWS
#include "H5FDwindows.h" 
#endif

#include "H5VLnative_private.h" 

#define H5F_ACS_META_CACHE_INIT_CONFIG_SIZE sizeof(H5AC_cache_config_t)
#define H5F_ACS_META_CACHE_INIT_CONFIG_DEF  H5AC__DEFAULT_CACHE_CONFIG
#define H5F_ACS_META_CACHE_INIT_CONFIG_ENC  H5P__facc_cache_config_enc
#define H5F_ACS_META_CACHE_INIT_CONFIG_DEC  H5P__facc_cache_config_dec
#define H5F_ACS_META_CACHE_INIT_CONFIG_CMP  H5P__facc_cache_config_cmp

#define H5F_ACS_DATA_CACHE_NUM_SLOTS_SIZE sizeof(size_t)
#define H5F_ACS_DATA_CACHE_NUM_SLOTS_DEF  8191
#define H5F_ACS_DATA_CACHE_NUM_SLOTS_ENC  H5P__encode_size_t
#define H5F_ACS_DATA_CACHE_NUM_SLOTS_DEC  H5P__decode_size_t

#define H5F_ACS_DATA_CACHE_BYTE_SIZE_SIZE sizeof(size_t)
#define H5F_ACS_DATA_CACHE_BYTE_SIZE_DEF  (8 * 1024 * 1024)
#define H5F_ACS_DATA_CACHE_BYTE_SIZE_ENC  H5P__encode_size_t
#define H5F_ACS_DATA_CACHE_BYTE_SIZE_DEC  H5P__decode_size_t

#define H5F_ACS_PREEMPT_READ_CHUNKS_SIZE sizeof(double)
#define H5F_ACS_PREEMPT_READ_CHUNKS_DEF  0.75
#define H5F_ACS_PREEMPT_READ_CHUNKS_ENC  H5P__encode_double
#define H5F_ACS_PREEMPT_READ_CHUNKS_DEC  H5P__decode_double

#define H5F_ACS_ALIGN_THRHD_SIZE sizeof(hsize_t)
#define H5F_ACS_ALIGN_THRHD_DEF  H5F_ALIGN_THRHD_DEF
#define H5F_ACS_ALIGN_THRHD_ENC  H5P__encode_hsize_t
#define H5F_ACS_ALIGN_THRHD_DEC  H5P__decode_hsize_t

#define H5F_ACS_ALIGN_SIZE sizeof(hsize_t)
#define H5F_ACS_ALIGN_DEF  H5F_ALIGN_DEF
#define H5F_ACS_ALIGN_ENC  H5P__encode_hsize_t
#define H5F_ACS_ALIGN_DEC  H5P__decode_hsize_t

#define H5F_ACS_META_BLOCK_SIZE_SIZE sizeof(hsize_t)
#define H5F_ACS_META_BLOCK_SIZE_DEF  H5F_META_BLOCK_SIZE_DEF
#define H5F_ACS_META_BLOCK_SIZE_ENC  H5P__encode_hsize_t
#define H5F_ACS_META_BLOCK_SIZE_DEC  H5P__decode_hsize_t

#define H5F_ACS_SIEVE_BUF_SIZE_SIZE sizeof(size_t)
#define H5F_ACS_SIEVE_BUF_SIZE_DEF  (64 * 1024)
#define H5F_ACS_SIEVE_BUF_SIZE_ENC  H5P__encode_size_t
#define H5F_ACS_SIEVE_BUF_SIZE_DEC  H5P__decode_size_t

#define H5F_ACS_SDATA_BLOCK_SIZE_SIZE sizeof(hsize_t)
#define H5F_ACS_SDATA_BLOCK_SIZE_DEF  H5F_SDATA_BLOCK_SIZE_DEF
#define H5F_ACS_SDATA_BLOCK_SIZE_ENC  H5P__encode_hsize_t
#define H5F_ACS_SDATA_BLOCK_SIZE_DEC  H5P__decode_hsize_t

#define H5F_ACS_GARBG_COLCT_REF_SIZE sizeof(unsigned)
#define H5F_ACS_GARBG_COLCT_REF_DEF  0
#define H5F_ACS_GARBG_COLCT_REF_ENC  H5P__encode_unsigned
#define H5F_ACS_GARBG_COLCT_REF_DEC  H5P__decode_unsigned

#define H5F_ACS_FILE_DRV_SIZE sizeof(H5FD_driver_prop_t)
#define H5F_ACS_FILE_DRV_DEF                                                                                 \
    {                                                                                                        \
        H5_DEFAULT_VFD, NULL, NULL                                                                           \
    }
#define H5F_ACS_FILE_DRV_CRT   H5P__facc_file_driver_create
#define H5F_ACS_FILE_DRV_SET   H5P__facc_file_driver_set
#define H5F_ACS_FILE_DRV_GET   H5P__facc_file_driver_get
#define H5F_ACS_FILE_DRV_DEL   H5P__facc_file_driver_del
#define H5F_ACS_FILE_DRV_COPY  H5P__facc_file_driver_copy
#define H5F_ACS_FILE_DRV_CMP   H5P__facc_file_driver_cmp
#define H5F_ACS_FILE_DRV_CLOSE H5P__facc_file_driver_close

#define H5F_CLOSE_DEGREE_SIZE sizeof(H5F_close_degree_t)
#define H5F_CLOSE_DEGREE_DEF  H5F_CLOSE_DEFAULT
#define H5F_CLOSE_DEGREE_ENC  H5P__facc_fclose_degree_enc
#define H5F_CLOSE_DEGREE_DEC  H5P__facc_fclose_degree_dec

#define H5F_ACS_FAMILY_OFFSET_SIZE sizeof(hsize_t)
#define H5F_ACS_FAMILY_OFFSET_DEF  0
#define H5F_ACS_FAMILY_OFFSET_ENC  H5P__encode_hsize_t
#define H5F_ACS_FAMILY_OFFSET_DEC  H5P__decode_hsize_t

#define H5F_ACS_FAMILY_NEWSIZE_SIZE sizeof(hsize_t)
#define H5F_ACS_FAMILY_NEWSIZE_DEF  0

#define H5F_ACS_FAMILY_TO_SINGLE_SIZE sizeof(bool)
#define H5F_ACS_FAMILY_TO_SINGLE_DEF  false

#define H5F_ACS_MULTI_TYPE_SIZE sizeof(H5FD_mem_t)
#define H5F_ACS_MULTI_TYPE_DEF  H5FD_MEM_DEFAULT
#define H5F_ACS_MULTI_TYPE_ENC  H5P__facc_multi_type_enc
#define H5F_ACS_MULTI_TYPE_DEC  H5P__facc_multi_type_dec

#define H5F_ACS_LIBVER_LOW_BOUND_SIZE sizeof(H5F_libver_t)
#define H5F_ACS_LIBVER_LOW_BOUND_DEF  H5F_LIBVER_V18
#define H5F_ACS_LIBVER_LOW_BOUND_ENC  H5P__facc_libver_type_enc
#define H5F_ACS_LIBVER_LOW_BOUND_DEC  H5P__facc_libver_type_dec

#define H5F_ACS_LIBVER_HIGH_BOUND_SIZE sizeof(H5F_libver_t)
#define H5F_ACS_LIBVER_HIGH_BOUND_DEF  H5F_LIBVER_LATEST
#define H5F_ACS_LIBVER_HIGH_BOUND_ENC  H5P__facc_libver_type_enc
#define H5F_ACS_LIBVER_HIGH_BOUND_DEC  H5P__facc_libver_type_dec

#define H5F_ACS_WANT_POSIX_FD_SIZE sizeof(bool)
#define H5F_ACS_WANT_POSIX_FD_DEF  false

#define H5F_ACS_EFC_SIZE_SIZE sizeof(unsigned)
#define H5F_ACS_EFC_SIZE_DEF  0
#define H5F_ACS_EFC_SIZE_ENC  H5P__encode_unsigned
#define H5F_ACS_EFC_SIZE_DEC  H5P__decode_unsigned

#define H5F_ACS_FILE_IMAGE_INFO_SIZE  sizeof(H5FD_file_image_info_t)
#define H5F_ACS_FILE_IMAGE_INFO_DEF   H5FD_DEFAULT_FILE_IMAGE_INFO
#define H5F_ACS_FILE_IMAGE_INFO_SET   H5P__facc_file_image_info_set
#define H5F_ACS_FILE_IMAGE_INFO_GET   H5P__facc_file_image_info_get
#define H5F_ACS_FILE_IMAGE_INFO_DEL   H5P__facc_file_image_info_del
#define H5F_ACS_FILE_IMAGE_INFO_COPY  H5P__facc_file_image_info_copy
#define H5F_ACS_FILE_IMAGE_INFO_CMP   H5P__facc_file_image_info_cmp
#define H5F_ACS_FILE_IMAGE_INFO_CLOSE H5P__facc_file_image_info_close

#define H5F_ACS_METADATA_READ_ATTEMPTS_SIZE sizeof(unsigned)
#define H5F_ACS_METADATA_READ_ATTEMPTS_DEF  0
#define H5F_ACS_METADATA_READ_ATTEMPTS_ENC  H5P__encode_unsigned
#define H5F_ACS_METADATA_READ_ATTEMPTS_DEC  H5P__decode_unsigned

#define H5F_ACS_OBJECT_FLUSH_CB_SIZE sizeof(H5F_object_flush_t)
#define H5F_ACS_OBJECT_FLUSH_CB_DEF                                                                          \
    {                                                                                                        \
        NULL, NULL                                                                                           \
    }

#define H5F_ACS_CLEAR_STATUS_FLAGS_SIZE sizeof(bool)
#define H5F_ACS_CLEAR_STATUS_FLAGS_DEF  false

#define H5F_ACS_NULL_FSM_ADDR_SIZE sizeof(bool)
#define H5F_ACS_NULL_FSM_ADDR_DEF  false

#define H5F_ACS_SKIP_EOF_CHECK_SIZE sizeof(bool)
#define H5F_ACS_SKIP_EOF_CHECK_DEF  false

#define H5F_ACS_USE_MDC_LOGGING_SIZE sizeof(bool)
#define H5F_ACS_USE_MDC_LOGGING_DEF  false
#define H5F_ACS_USE_MDC_LOGGING_ENC  H5P__encode_bool
#define H5F_ACS_USE_MDC_LOGGING_DEC  H5P__decode_bool

#define H5F_ACS_MDC_LOG_LOCATION_SIZE  sizeof(char *)
#define H5F_ACS_MDC_LOG_LOCATION_DEF   NULL 
#define H5F_ACS_MDC_LOG_LOCATION_ENC   H5P__facc_mdc_log_location_enc
#define H5F_ACS_MDC_LOG_LOCATION_DEC   H5P__facc_mdc_log_location_dec
#define H5F_ACS_MDC_LOG_LOCATION_DEL   H5P__facc_mdc_log_location_del
#define H5F_ACS_MDC_LOG_LOCATION_COPY  H5P__facc_mdc_log_location_copy
#define H5F_ACS_MDC_LOG_LOCATION_CMP   H5P__facc_mdc_log_location_cmp
#define H5F_ACS_MDC_LOG_LOCATION_CLOSE H5P__facc_mdc_log_location_close

#define H5F_ACS_START_MDC_LOG_ON_ACCESS_SIZE sizeof(bool)
#define H5F_ACS_START_MDC_LOG_ON_ACCESS_DEF  false
#define H5F_ACS_START_MDC_LOG_ON_ACCESS_ENC  H5P__encode_bool
#define H5F_ACS_START_MDC_LOG_ON_ACCESS_DEC  H5P__decode_bool

#define H5F_ACS_EVICT_ON_CLOSE_FLAG_SIZE sizeof(bool)
#define H5F_ACS_EVICT_ON_CLOSE_FLAG_DEF  false
#define H5F_ACS_EVICT_ON_CLOSE_FLAG_ENC  H5P__encode_bool
#define H5F_ACS_EVICT_ON_CLOSE_FLAG_DEC  H5P__decode_bool
#ifdef H5_HAVE_PARALLEL

#define H5F_ACS_COLL_MD_READ_FLAG_SIZE sizeof(H5P_coll_md_read_flag_t)
#define H5F_ACS_COLL_MD_READ_FLAG_DEF  H5P_USER_FALSE
#define H5F_ACS_COLL_MD_READ_FLAG_ENC  H5P__encode_coll_md_read_flag_t
#define H5F_ACS_COLL_MD_READ_FLAG_DEC  H5P__decode_coll_md_read_flag_t

#define H5F_ACS_COLL_MD_WRITE_FLAG_SIZE sizeof(bool)
#define H5F_ACS_COLL_MD_WRITE_FLAG_DEF  false
#define H5F_ACS_COLL_MD_WRITE_FLAG_ENC  H5P__encode_bool
#define H5F_ACS_COLL_MD_WRITE_FLAG_DEC  H5P__decode_bool

#define H5F_ACS_MPI_PARAMS_COMM_SIZE  sizeof(MPI_Comm)
#define H5F_ACS_MPI_PARAMS_COMM_DEF   MPI_COMM_NULL
#define H5F_ACS_MPI_PARAMS_COMM_SET   H5P__facc_mpi_comm_set
#define H5F_ACS_MPI_PARAMS_COMM_GET   H5P__facc_mpi_comm_get
#define H5F_ACS_MPI_PARAMS_COMM_DEL   H5P__facc_mpi_comm_del
#define H5F_ACS_MPI_PARAMS_COMM_COPY  H5P__facc_mpi_comm_copy
#define H5F_ACS_MPI_PARAMS_COMM_CMP   H5P__facc_mpi_comm_cmp
#define H5F_ACS_MPI_PARAMS_COMM_CLOSE H5P__facc_mpi_comm_close

#define H5F_ACS_MPI_PARAMS_INFO_SIZE  sizeof(MPI_Info)
#define H5F_ACS_MPI_PARAMS_INFO_DEF   MPI_INFO_NULL
#define H5F_ACS_MPI_PARAMS_INFO_SET   H5P__facc_mpi_info_set
#define H5F_ACS_MPI_PARAMS_INFO_GET   H5P__facc_mpi_info_get
#define H5F_ACS_MPI_PARAMS_INFO_DEL   H5P__facc_mpi_info_del
#define H5F_ACS_MPI_PARAMS_INFO_COPY  H5P__facc_mpi_info_copy
#define H5F_ACS_MPI_PARAMS_INFO_CMP   H5P__facc_mpi_info_cmp
#define H5F_ACS_MPI_PARAMS_INFO_CLOSE H5P__facc_mpi_info_close
#endif 

#define H5F_ACS_META_CACHE_INIT_IMAGE_CONFIG_SIZE sizeof(H5AC_cache_image_config_t)
#define H5F_ACS_META_CACHE_INIT_IMAGE_CONFIG_DEF  H5AC__DEFAULT_CACHE_IMAGE_CONFIG
#define H5F_ACS_META_CACHE_INIT_IMAGE_CONFIG_ENC  H5P__facc_cache_image_config_enc
#define H5F_ACS_META_CACHE_INIT_IMAGE_CONFIG_DEC  H5P__facc_cache_image_config_dec
#define H5F_ACS_META_CACHE_INIT_IMAGE_CONFIG_CMP  H5P__facc_cache_image_config_cmp

#define H5F_ACS_PAGE_BUFFER_SIZE_SIZE sizeof(size_t)
#define H5F_ACS_PAGE_BUFFER_SIZE_DEF  H5F_PAGE_BUFFER_SIZE_DEFAULT
#define H5F_ACS_PAGE_BUFFER_SIZE_ENC  H5P__facc_page_buffer_size_enc
#define H5F_ACS_PAGE_BUFFER_SIZE_DEC  H5P__facc_page_buffer_size_dec

#define H5F_ACS_PAGE_BUFFER_MIN_META_PERC_SIZE sizeof(unsigned)
#define H5F_ACS_PAGE_BUFFER_MIN_META_PERC_DEF  0
#define H5F_ACS_PAGE_BUFFER_MIN_META_PERC_ENC  H5P__encode_unsigned
#define H5F_ACS_PAGE_BUFFER_MIN_META_PERC_DEC  H5P__decode_unsigned

#define H5F_ACS_PAGE_BUFFER_MIN_RAW_PERC_SIZE sizeof(unsigned)
#define H5F_ACS_PAGE_BUFFER_MIN_RAW_PERC_DEF  0
#define H5F_ACS_PAGE_BUFFER_MIN_RAW_PERC_ENC  H5P__encode_unsigned
#define H5F_ACS_PAGE_BUFFER_MIN_RAW_PERC_DEC  H5P__decode_unsigned

#define H5F_ACS_VOL_CONN_SIZE sizeof(H5VL_connector_prop_t)
#define H5F_ACS_VOL_CONN_DEF                                                                                 \
    {                                                                                                        \
        H5_DEFAULT_VOL, NULL                                                                                 \
    }
#define H5F_ACS_VOL_CONN_CRT   H5P__facc_vol_create
#define H5F_ACS_VOL_CONN_SET   H5P__facc_vol_set
#define H5F_ACS_VOL_CONN_GET   H5P__facc_vol_get
#define H5F_ACS_VOL_CONN_DEL   H5P__facc_vol_del
#define H5F_ACS_VOL_CONN_COPY  H5P__facc_vol_copy
#define H5F_ACS_VOL_CONN_CMP   H5P__facc_vol_cmp
#define H5F_ACS_VOL_CONN_CLOSE H5P__facc_vol_close

#define H5F_ACS_USE_FILE_LOCKING_SIZE sizeof(bool)
#if defined H5_USE_FILE_LOCKING && H5_USE_FILE_LOCKING
#define H5F_ACS_USE_FILE_LOCKING_DEF true
#else
#define H5F_ACS_USE_FILE_LOCKING_DEF false
#endif
#define H5F_ACS_USE_FILE_LOCKING_ENC H5P__encode_bool
#define H5F_ACS_USE_FILE_LOCKING_DEC H5P__decode_bool

#define H5F_ACS_IGNORE_DISABLED_FILE_LOCKS_SIZE sizeof(bool)
#if defined H5_IGNORE_DISABLED_FILE_LOCKS && H5_IGNORE_DISABLED_FILE_LOCKS
#define H5F_ACS_IGNORE_DISABLED_FILE_LOCKS_DEF true
#else
#define H5F_ACS_IGNORE_DISABLED_FILE_LOCKS_DEF false
#endif
#define H5F_ACS_IGNORE_DISABLED_FILE_LOCKS_ENC H5P__encode_bool
#define H5F_ACS_IGNORE_DISABLED_FILE_LOCKS_DEC H5P__decode_bool

#define H5F_ACS_RFIC_FLAGS_SIZE sizeof(uint64_t)
#define H5F_ACS_RFIC_FLAGS_DEF  0
#define H5F_ACS_RFIC_FLAGS_ENC  H5P__encode_uint64_t
#define H5F_ACS_RFIC_FLAGS_DEC  H5P__decode_uint64_t

static herr_t H5P__facc_reg_prop(H5P_genclass_t *pclass);

static herr_t H5P__facc_file_driver_create(const char *name, size_t size, void *value);
static herr_t H5P__facc_file_driver_set(hid_t prop_id, const char *name, size_t size, void *value);
static herr_t H5P__facc_file_driver_get(hid_t prop_id, const char *name, size_t size, void *value);
static herr_t H5P__facc_file_driver_del(hid_t prop_id, const char *name, size_t size, void *value);
static herr_t H5P__facc_file_driver_copy(const char *name, size_t size, void *value);
static int    H5P__facc_file_driver_cmp(const void *value1, const void *value2, size_t size);
static herr_t H5P__facc_file_driver_close(const char *name, size_t size, void *value);

static herr_t H5P__file_image_info_copy(void *value);
static herr_t H5P__file_image_info_free(void *value);
static herr_t H5P__facc_file_image_info_set(hid_t prop_id, const char *name, size_t size, void *value);
static herr_t H5P__facc_file_image_info_get(hid_t prop_id, const char *name, size_t size, void *value);
static herr_t H5P__facc_file_image_info_del(hid_t prop_id, const char *name, size_t size, void *value);
static herr_t H5P__facc_file_image_info_copy(const char *name, size_t size, void *value);
static int    H5P__facc_file_image_info_cmp(const void *value1, const void *value2, size_t size);
static herr_t H5P__facc_file_image_info_close(const char *name, size_t size, void *value);

static herr_t H5P__facc_cache_config_enc(const void *value, void **_pp, size_t *size);
static herr_t H5P__facc_cache_config_dec(const void **_pp, void *value);
static int    H5P__facc_cache_config_cmp(const void *value1, const void *value2, size_t size);
static herr_t H5P__facc_fclose_degree_enc(const void *value, void **_pp, size_t *size);
static herr_t H5P__facc_fclose_degree_dec(const void **pp, void *value);
static herr_t H5P__facc_multi_type_enc(const void *value, void **_pp, size_t *size);
static herr_t H5P__facc_multi_type_dec(const void **_pp, void *value);
static herr_t H5P__facc_libver_type_enc(const void *value, void **_pp, size_t *size);
static herr_t H5P__facc_libver_type_dec(const void **_pp, void *value);
static herr_t H5P__facc_page_buffer_size_enc(const void *value, void **_pp, size_t *size);
static herr_t H5P__facc_page_buffer_size_dec(const void **_pp, void *value);

static herr_t H5P__facc_mdc_log_location_enc(const void *value, void **_pp, size_t *size);
static herr_t H5P__facc_mdc_log_location_dec(const void **_pp, void *value);
static herr_t H5P__facc_mdc_log_location_del(hid_t prop_id, const char *name, size_t size, void *value);
static herr_t H5P__facc_mdc_log_location_copy(const char *name, size_t size, void *value);
static int    H5P__facc_mdc_log_location_cmp(const void *value1, const void *value2, size_t size);
static herr_t H5P__facc_mdc_log_location_close(const char *name, size_t size, void *value);

static int    H5P__facc_cache_image_config_cmp(const void *_config1, const void *_config2,
                                               size_t H5_ATTR_UNUSED size);
static herr_t H5P__facc_cache_image_config_enc(const void *value, void **_pp, size_t *size);
static herr_t H5P__facc_cache_image_config_dec(const void **_pp, void *_value);

static herr_t H5P__facc_vol_create(const char *name, size_t size, void *value);
static herr_t H5P__facc_vol_set(hid_t prop_id, const char *name, size_t size, void *value);
static herr_t H5P__facc_vol_get(hid_t prop_id, const char *name, size_t size, void *value);
static herr_t H5P__facc_vol_del(hid_t prop_id, const char *name, size_t size, void *value);
static herr_t H5P__facc_vol_copy(const char *name, size_t size, void *value);
static int    H5P__facc_vol_cmp(const void *value1, const void *value2, size_t size);
static herr_t H5P__facc_vol_close(const char *name, size_t size, void *value);

#ifdef H5_HAVE_PARALLEL

static herr_t H5P__facc_mpi_comm_set(hid_t prop_id, const char *name, size_t size, void *value);
static herr_t H5P__facc_mpi_comm_get(hid_t prop_id, const char *name, size_t size, void *value);
static herr_t H5P__facc_mpi_comm_del(hid_t prop_id, const char *name, size_t size, void *value);
static herr_t H5P__facc_mpi_comm_copy(const char *name, size_t size, void *value);
static int    H5P__facc_mpi_comm_cmp(const void *value1, const void *value2, size_t size);
static herr_t H5P__facc_mpi_comm_close(const char *name, size_t size, void *value);

static herr_t H5P__facc_mpi_info_set(hid_t prop_id, const char *name, size_t size, void *value);
static herr_t H5P__facc_mpi_info_get(hid_t prop_id, const char *name, size_t size, void *value);
static herr_t H5P__facc_mpi_info_del(hid_t prop_id, const char *name, size_t size, void *value);
static herr_t H5P__facc_mpi_info_copy(const char *name, size_t size, void *value);
static int    H5P__facc_mpi_info_cmp(const void *value1, const void *value2, size_t size);
static herr_t H5P__facc_mpi_info_close(const char *name, size_t size, void *value);
#endif 

static herr_t H5P__facc_set_def_driver_check_predefined(const char *driver_name, hid_t *driver_id);

const H5P_libclass_t H5P_CLS_FACC[1] = {{
    "file access",        
    H5P_TYPE_FILE_ACCESS, 

    &H5P_CLS_ROOT_g,           
    &H5P_CLS_FILE_ACCESS_g,    
    &H5P_CLS_FILE_ACCESS_ID_g, 
    &H5P_LST_FILE_ACCESS_ID_g, 
    H5P__facc_reg_prop,        

    NULL, 
    NULL, 
    NULL, 
    NULL, 
    NULL, 
    NULL  
}};

static const H5AC_cache_config_t H5F_def_mdc_initCacheCfg_g =
    H5F_ACS_META_CACHE_INIT_CONFIG_DEF; 
static const size_t H5F_def_rdcc_nslots_g =
    H5F_ACS_DATA_CACHE_NUM_SLOTS_DEF; 
static const size_t H5F_def_rdcc_nbytes_g =
    H5F_ACS_DATA_CACHE_BYTE_SIZE_DEF; 
static const double H5F_def_rdcc_w0_g =
    H5F_ACS_PREEMPT_READ_CHUNKS_DEF; 
static const hsize_t H5F_def_threshold_g =
    H5F_ACS_ALIGN_THRHD_DEF;                                  
static const hsize_t H5F_def_alignment_g = H5F_ACS_ALIGN_DEF; 
static const hsize_t H5F_def_meta_block_size_g =
    H5F_ACS_META_BLOCK_SIZE_DEF; 
static const size_t H5F_def_sieve_buf_size_g =
    H5F_ACS_SIEVE_BUF_SIZE_DEF; 
static const hsize_t H5F_def_sdata_block_size_g =
    H5F_ACS_SDATA_BLOCK_SIZE_DEF; 
static const unsigned H5F_def_gc_ref_g =
    H5F_ACS_GARBG_COLCT_REF_DEF; 
static const H5F_close_degree_t H5F_def_close_degree_g = H5F_CLOSE_DEGREE_DEF; 
static const hsize_t H5F_def_family_offset_g = H5F_ACS_FAMILY_OFFSET_DEF; 
static const hsize_t H5F_def_family_newsize_g =
    H5F_ACS_FAMILY_NEWSIZE_DEF; 
static const bool H5F_def_family_to_single_g = H5F_ACS_FAMILY_TO_SINGLE_DEF; 
static const H5FD_mem_t H5F_def_mem_type_g =
    H5F_ACS_MULTI_TYPE_DEF; 

static const H5F_libver_t H5F_def_libver_low_bound_g =
    H5F_ACS_LIBVER_LOW_BOUND_DEF; 
static const H5F_libver_t H5F_def_libver_high_bound_g =
    H5F_ACS_LIBVER_HIGH_BOUND_DEF; 

static const bool H5F_def_want_posix_fd_g =
    H5F_ACS_WANT_POSIX_FD_DEF; 
static const unsigned H5F_def_efc_size_g = H5F_ACS_EFC_SIZE_DEF; 
static const H5FD_file_image_info_t H5F_def_file_image_info_g =
    H5F_ACS_FILE_IMAGE_INFO_DEF; 
static const unsigned H5F_def_metadata_read_attempts_g =
    H5F_ACS_METADATA_READ_ATTEMPTS_DEF; 
static const H5F_object_flush_t H5F_def_object_flush_cb_g =
    H5F_ACS_OBJECT_FLUSH_CB_DEF; 
static const bool H5F_def_clear_status_flags_g =
    H5F_ACS_CLEAR_STATUS_FLAGS_DEF; 
static const bool H5F_def_skip_eof_check_g =
    H5F_ACS_SKIP_EOF_CHECK_DEF; 
static const bool H5F_def_null_fsm_addr_g =
    H5F_ACS_NULL_FSM_ADDR_DEF; 

static const bool H5F_def_use_mdc_logging_g =
    H5F_ACS_USE_MDC_LOGGING_DEF; 
static const char *H5F_def_mdc_log_location_g = H5F_ACS_MDC_LOG_LOCATION_DEF; 
static const bool  H5F_def_start_mdc_log_on_access_g =
    H5F_ACS_START_MDC_LOG_ON_ACCESS_DEF; 
static const bool H5F_def_evict_on_close_flag_g =
    H5F_ACS_EVICT_ON_CLOSE_FLAG_DEF; 
#ifdef H5_HAVE_PARALLEL
static const H5P_coll_md_read_flag_t H5F_def_coll_md_read_flag_g =
    H5F_ACS_COLL_MD_READ_FLAG_DEF; 
static const bool H5F_def_coll_md_write_flag_g =
    H5F_ACS_COLL_MD_WRITE_FLAG_DEF; 
static const MPI_Comm H5F_def_mpi_params_comm_g = H5F_ACS_MPI_PARAMS_COMM_DEF; 
static const MPI_Info H5F_def_mpi_params_info_g = H5F_ACS_MPI_PARAMS_INFO_DEF; 
#endif                                                                         
static const H5AC_cache_image_config_t H5F_def_mdc_initCacheImageCfg_g =
    H5F_ACS_META_CACHE_INIT_IMAGE_CONFIG_DEF; 
static const size_t   H5F_def_page_buf_size_g = H5F_ACS_PAGE_BUFFER_SIZE_DEF; 
static const unsigned H5F_def_page_buf_min_meta_perc_g =
    H5F_ACS_PAGE_BUFFER_MIN_META_PERC_DEF; 
static const unsigned H5F_def_page_buf_min_raw_perc_g =
    H5F_ACS_PAGE_BUFFER_MIN_RAW_PERC_DEF; 
static const bool H5F_def_use_file_locking_g =
    H5F_ACS_USE_FILE_LOCKING_DEF; 
static const bool H5F_def_ignore_disabled_file_locks_g =
    H5F_ACS_IGNORE_DISABLED_FILE_LOCKS_DEF; 
static const uint64_t H5F_def_rfic_flags_g = H5F_ACS_RFIC_FLAGS_DEF; 

static herr_t
H5P__facc_reg_prop(H5P_genclass_t *pclass)
{
    const H5FD_driver_prop_t def_driver_prop =
        H5F_ACS_FILE_DRV_DEF; 
    const H5VL_connector_prop_t def_vol_prop =
        H5F_ACS_VOL_CONN_DEF;   
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (H5P__register_real(pclass, H5F_ACS_META_CACHE_INIT_CONFIG_NAME, H5F_ACS_META_CACHE_INIT_CONFIG_SIZE,
                           &H5F_def_mdc_initCacheCfg_g, NULL, NULL, NULL, H5F_ACS_META_CACHE_INIT_CONFIG_ENC,
                           H5F_ACS_META_CACHE_INIT_CONFIG_DEC, NULL, NULL, H5F_ACS_META_CACHE_INIT_CONFIG_CMP,
                           NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_DATA_CACHE_NUM_SLOTS_NAME, H5F_ACS_DATA_CACHE_NUM_SLOTS_SIZE,
                           &H5F_def_rdcc_nslots_g, NULL, NULL, NULL, H5F_ACS_DATA_CACHE_NUM_SLOTS_ENC,
                           H5F_ACS_DATA_CACHE_NUM_SLOTS_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_DATA_CACHE_BYTE_SIZE_NAME, H5F_ACS_DATA_CACHE_BYTE_SIZE_SIZE,
                           &H5F_def_rdcc_nbytes_g, NULL, NULL, NULL, H5F_ACS_DATA_CACHE_BYTE_SIZE_ENC,
                           H5F_ACS_DATA_CACHE_BYTE_SIZE_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_PREEMPT_READ_CHUNKS_NAME, H5F_ACS_PREEMPT_READ_CHUNKS_SIZE,
                           &H5F_def_rdcc_w0_g, NULL, NULL, NULL, H5F_ACS_PREEMPT_READ_CHUNKS_ENC,
                           H5F_ACS_PREEMPT_READ_CHUNKS_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_ALIGN_THRHD_NAME, H5F_ACS_ALIGN_THRHD_SIZE, &H5F_def_threshold_g,
                           NULL, NULL, NULL, H5F_ACS_ALIGN_THRHD_ENC, H5F_ACS_ALIGN_THRHD_DEC, NULL, NULL,
                           NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_ALIGN_NAME, H5F_ACS_ALIGN_SIZE, &H5F_def_alignment_g, NULL, NULL,
                           NULL, H5F_ACS_ALIGN_ENC, H5F_ACS_ALIGN_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_META_BLOCK_SIZE_NAME, H5F_ACS_META_BLOCK_SIZE_SIZE,
                           &H5F_def_meta_block_size_g, NULL, NULL, NULL, H5F_ACS_META_BLOCK_SIZE_ENC,
                           H5F_ACS_META_BLOCK_SIZE_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_SIEVE_BUF_SIZE_NAME, H5F_ACS_SIEVE_BUF_SIZE_SIZE,
                           &H5F_def_sieve_buf_size_g, NULL, NULL, NULL, H5F_ACS_SIEVE_BUF_SIZE_ENC,
                           H5F_ACS_SIEVE_BUF_SIZE_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_SDATA_BLOCK_SIZE_NAME, H5F_ACS_SDATA_BLOCK_SIZE_SIZE,
                           &H5F_def_sdata_block_size_g, NULL, NULL, NULL, H5F_ACS_SDATA_BLOCK_SIZE_ENC,
                           H5F_ACS_SDATA_BLOCK_SIZE_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_GARBG_COLCT_REF_NAME, H5F_ACS_GARBG_COLCT_REF_SIZE,
                           &H5F_def_gc_ref_g, NULL, NULL, NULL, H5F_ACS_GARBG_COLCT_REF_ENC,
                           H5F_ACS_GARBG_COLCT_REF_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    
    if (H5P__register_real(pclass, H5F_ACS_FILE_DRV_NAME, H5F_ACS_FILE_DRV_SIZE, &def_driver_prop,
                           H5F_ACS_FILE_DRV_CRT, H5F_ACS_FILE_DRV_SET, H5F_ACS_FILE_DRV_GET, NULL, NULL,
                           H5F_ACS_FILE_DRV_DEL, H5F_ACS_FILE_DRV_COPY, H5F_ACS_FILE_DRV_CMP,
                           H5F_ACS_FILE_DRV_CLOSE) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_CLOSE_DEGREE_NAME, H5F_CLOSE_DEGREE_SIZE, &H5F_def_close_degree_g,
                           NULL, NULL, NULL, H5F_CLOSE_DEGREE_ENC, H5F_CLOSE_DEGREE_DEC, NULL, NULL, NULL,
                           NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_FAMILY_OFFSET_NAME, H5F_ACS_FAMILY_OFFSET_SIZE,
                           &H5F_def_family_offset_g, NULL, NULL, NULL, H5F_ACS_FAMILY_OFFSET_ENC,
                           H5F_ACS_FAMILY_OFFSET_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    
    if (H5P__register_real(pclass, H5F_ACS_FAMILY_NEWSIZE_NAME, H5F_ACS_FAMILY_NEWSIZE_SIZE,
                           &H5F_def_family_newsize_g, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
                           NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    
    if (H5P__register_real(pclass, H5F_ACS_FAMILY_TO_SINGLE_NAME, H5F_ACS_FAMILY_TO_SINGLE_SIZE,
                           &H5F_def_family_to_single_g, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
                           NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_MULTI_TYPE_NAME, H5F_ACS_MULTI_TYPE_SIZE, &H5F_def_mem_type_g,
                           NULL, NULL, NULL, H5F_ACS_MULTI_TYPE_ENC, H5F_ACS_MULTI_TYPE_DEC, NULL, NULL, NULL,
                           NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_LIBVER_LOW_BOUND_NAME, H5F_ACS_LIBVER_LOW_BOUND_SIZE,
                           &H5F_def_libver_low_bound_g, NULL, NULL, NULL, H5F_ACS_LIBVER_LOW_BOUND_ENC,
                           H5F_ACS_LIBVER_LOW_BOUND_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_LIBVER_HIGH_BOUND_NAME, H5F_ACS_LIBVER_HIGH_BOUND_SIZE,
                           &H5F_def_libver_high_bound_g, NULL, NULL, NULL, H5F_ACS_LIBVER_HIGH_BOUND_ENC,
                           H5F_ACS_LIBVER_HIGH_BOUND_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    
    
    if (H5P__register_real(pclass, H5F_ACS_WANT_POSIX_FD_NAME, H5F_ACS_WANT_POSIX_FD_SIZE,
                           &H5F_def_want_posix_fd_g, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
                           NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_EFC_SIZE_NAME, H5F_ACS_EFC_SIZE_SIZE, &H5F_def_efc_size_g, NULL,
                           NULL, NULL, H5F_ACS_EFC_SIZE_ENC, H5F_ACS_EFC_SIZE_DEC, NULL, NULL, NULL,
                           NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    
    if (H5P__register_real(pclass, H5F_ACS_FILE_IMAGE_INFO_NAME, H5F_ACS_FILE_IMAGE_INFO_SIZE,
                           &H5F_def_file_image_info_g, NULL, H5F_ACS_FILE_IMAGE_INFO_SET,
                           H5F_ACS_FILE_IMAGE_INFO_GET, NULL, NULL, H5F_ACS_FILE_IMAGE_INFO_DEL,
                           H5F_ACS_FILE_IMAGE_INFO_COPY, H5F_ACS_FILE_IMAGE_INFO_CMP,
                           H5F_ACS_FILE_IMAGE_INFO_CLOSE) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_METADATA_READ_ATTEMPTS_NAME, H5F_ACS_METADATA_READ_ATTEMPTS_SIZE,
                           &H5F_def_metadata_read_attempts_g, NULL, NULL, NULL,
                           H5F_ACS_METADATA_READ_ATTEMPTS_ENC, H5F_ACS_METADATA_READ_ATTEMPTS_DEC, NULL, NULL,
                           NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    
    if (H5P__register_real(pclass, H5F_ACS_OBJECT_FLUSH_CB_NAME, H5F_ACS_OBJECT_FLUSH_CB_SIZE,
                           &H5F_def_object_flush_cb_g, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
                           NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_CLEAR_STATUS_FLAGS_NAME, H5F_ACS_CLEAR_STATUS_FLAGS_SIZE,
                           &H5F_def_clear_status_flags_g, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
                           NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_SKIP_EOF_CHECK_NAME, H5F_ACS_SKIP_EOF_CHECK_SIZE,
                           &H5F_def_skip_eof_check_g, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
                           NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_NULL_FSM_ADDR_NAME, H5F_ACS_NULL_FSM_ADDR_SIZE,
                           &H5F_def_null_fsm_addr_g, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
                           NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_USE_MDC_LOGGING_NAME, H5F_ACS_USE_MDC_LOGGING_SIZE,
                           &H5F_def_use_mdc_logging_g, NULL, NULL, NULL, H5F_ACS_USE_MDC_LOGGING_ENC,
                           H5F_ACS_USE_MDC_LOGGING_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_MDC_LOG_LOCATION_NAME, H5F_ACS_MDC_LOG_LOCATION_SIZE,
                           &H5F_def_mdc_log_location_g, NULL, NULL, NULL, H5F_ACS_MDC_LOG_LOCATION_ENC,
                           H5F_ACS_MDC_LOG_LOCATION_DEC, H5F_ACS_MDC_LOG_LOCATION_DEL,
                           H5F_ACS_MDC_LOG_LOCATION_COPY, H5F_ACS_MDC_LOG_LOCATION_CMP,
                           H5F_ACS_MDC_LOG_LOCATION_CLOSE) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_START_MDC_LOG_ON_ACCESS_NAME, H5F_ACS_START_MDC_LOG_ON_ACCESS_SIZE,
                           &H5F_def_start_mdc_log_on_access_g, NULL, NULL, NULL,
                           H5F_ACS_START_MDC_LOG_ON_ACCESS_ENC, H5F_ACS_START_MDC_LOG_ON_ACCESS_DEC, NULL,
                           NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_EVICT_ON_CLOSE_FLAG_NAME, H5F_ACS_EVICT_ON_CLOSE_FLAG_SIZE,
                           &H5F_def_evict_on_close_flag_g, NULL, NULL, NULL, H5F_ACS_EVICT_ON_CLOSE_FLAG_ENC,
                           H5F_ACS_EVICT_ON_CLOSE_FLAG_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

#ifdef H5_HAVE_PARALLEL
    
    if (H5P__register_real(pclass, H5_COLL_MD_READ_FLAG_NAME, H5F_ACS_COLL_MD_READ_FLAG_SIZE,
                           &H5F_def_coll_md_read_flag_g, NULL, NULL, NULL, H5F_ACS_COLL_MD_READ_FLAG_ENC,
                           H5F_ACS_COLL_MD_READ_FLAG_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_COLL_MD_WRITE_FLAG_NAME, H5F_ACS_COLL_MD_WRITE_FLAG_SIZE,
                           &H5F_def_coll_md_write_flag_g, NULL, NULL, NULL, H5F_ACS_COLL_MD_WRITE_FLAG_ENC,
                           H5F_ACS_COLL_MD_WRITE_FLAG_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_MPI_PARAMS_COMM_NAME, H5F_ACS_MPI_PARAMS_COMM_SIZE,
                           &H5F_def_mpi_params_comm_g, NULL, H5F_ACS_MPI_PARAMS_COMM_SET,
                           H5F_ACS_MPI_PARAMS_COMM_GET, NULL, NULL, H5F_ACS_MPI_PARAMS_COMM_DEL,
                           H5F_ACS_MPI_PARAMS_COMM_COPY, H5F_ACS_MPI_PARAMS_COMM_CMP,
                           H5F_ACS_MPI_PARAMS_COMM_CLOSE) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_MPI_PARAMS_INFO_NAME, H5F_ACS_MPI_PARAMS_INFO_SIZE,
                           &H5F_def_mpi_params_info_g, NULL, H5F_ACS_MPI_PARAMS_INFO_SET,
                           H5F_ACS_MPI_PARAMS_INFO_GET, NULL, NULL, H5F_ACS_MPI_PARAMS_INFO_DEL,
                           H5F_ACS_MPI_PARAMS_INFO_COPY, H5F_ACS_MPI_PARAMS_INFO_CMP,
                           H5F_ACS_MPI_PARAMS_INFO_CLOSE) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

#endif 

    
    if (H5P__register_real(pclass, H5F_ACS_META_CACHE_INIT_IMAGE_CONFIG_NAME,
                           H5F_ACS_META_CACHE_INIT_IMAGE_CONFIG_SIZE, &H5F_def_mdc_initCacheImageCfg_g, NULL,
                           NULL, NULL, H5F_ACS_META_CACHE_INIT_IMAGE_CONFIG_ENC,
                           H5F_ACS_META_CACHE_INIT_IMAGE_CONFIG_DEC, NULL, NULL,
                           H5F_ACS_META_CACHE_INIT_IMAGE_CONFIG_CMP, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_PAGE_BUFFER_SIZE_NAME, H5F_ACS_PAGE_BUFFER_SIZE_SIZE,
                           &H5F_def_page_buf_size_g, NULL, NULL, NULL, H5F_ACS_PAGE_BUFFER_SIZE_ENC,
                           H5F_ACS_PAGE_BUFFER_SIZE_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_PAGE_BUFFER_MIN_META_PERC_NAME,
                           H5F_ACS_PAGE_BUFFER_MIN_META_PERC_SIZE, &H5F_def_page_buf_min_meta_perc_g, NULL,
                           NULL, NULL, H5F_ACS_PAGE_BUFFER_MIN_META_PERC_ENC,
                           H5F_ACS_PAGE_BUFFER_MIN_META_PERC_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_PAGE_BUFFER_MIN_RAW_PERC_NAME,
                           H5F_ACS_PAGE_BUFFER_MIN_RAW_PERC_SIZE, &H5F_def_page_buf_min_raw_perc_g, NULL,
                           NULL, NULL, H5F_ACS_PAGE_BUFFER_MIN_RAW_PERC_ENC,
                           H5F_ACS_PAGE_BUFFER_MIN_RAW_PERC_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    
    if (H5P__register_real(pclass, H5F_ACS_VOL_CONN_NAME, H5F_ACS_VOL_CONN_SIZE, &def_vol_prop,
                           H5F_ACS_VOL_CONN_CRT, H5F_ACS_VOL_CONN_SET, H5F_ACS_VOL_CONN_GET, NULL, NULL,
                           H5F_ACS_VOL_CONN_DEL, H5F_ACS_VOL_CONN_COPY, H5F_ACS_VOL_CONN_CMP,
                           H5F_ACS_VOL_CONN_CLOSE) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_USE_FILE_LOCKING_NAME, H5F_ACS_USE_FILE_LOCKING_SIZE,
                           &H5F_def_use_file_locking_g, NULL, NULL, NULL, H5F_ACS_USE_FILE_LOCKING_ENC,
                           H5F_ACS_USE_FILE_LOCKING_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_IGNORE_DISABLED_FILE_LOCKS_NAME,
                           H5F_ACS_IGNORE_DISABLED_FILE_LOCKS_SIZE, &H5F_def_ignore_disabled_file_locks_g,
                           NULL, NULL, NULL, H5F_ACS_IGNORE_DISABLED_FILE_LOCKS_ENC,
                           H5F_ACS_IGNORE_DISABLED_FILE_LOCKS_DEC, NULL, NULL, NULL, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

    
    if (H5P__register_real(pclass, H5F_ACS_RFIC_FLAGS_NAME, H5F_ACS_RFIC_FLAGS_SIZE, &H5F_def_rfic_flags_g,
                           NULL, NULL, NULL, H5F_ACS_RFIC_FLAGS_ENC, H5F_ACS_RFIC_FLAGS_DEC, NULL, NULL, NULL,
                           NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTINSERT, FAIL, "can't insert property into class");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5P__facc_set_def_driver(void)
{
    const char *driver_env_var;
    bool        driver_ref_inc = false;
    hid_t       driver_id      = H5I_INVALID_HID; 
    herr_t      ret_value      = SUCCEED;

    FUNC_ENTER_PACKAGE

    
    driver_env_var = getenv(HDF5_DRIVER);

    
    if (driver_env_var && *driver_env_var) {
        H5FD_driver_prop_t driver_prop;
        H5P_genplist_t    *def_fapl;     
        H5P_genclass_t    *def_fapclass; 
        const char        *driver_config_env_var;
        htri_t             driver_is_registered;

        
        if ((driver_is_registered = H5FD_is_driver_registered_by_name(driver_env_var, &driver_id)) < 0)
            HGOTO_ERROR(H5E_VFL, H5E_CANTGET, FAIL, "can't check if VFL driver is already registered");
        if (driver_is_registered) {
            assert(driver_id >= 0);

            if (H5I_inc_ref(driver_id, true) < 0)
                HGOTO_ERROR(H5E_VFL, H5E_CANTINC, FAIL, "unable to increment ref count on VFD");
            driver_ref_inc = true;
        } 
        else {
            
            if (H5P__facc_set_def_driver_check_predefined(driver_env_var, &driver_id) < 0)
                HGOTO_ERROR(H5E_VFL, H5E_CANTGET, FAIL, "can't check for predefined VFL driver name");
            else if (driver_id > 0) {
                if (H5I_inc_ref(driver_id, true) < 0)
                    HGOTO_ERROR(H5E_VFL, H5E_CANTINC, FAIL, "can't increment VFL driver refcount");
                driver_ref_inc = true;
            }
            else {
                
                if ((driver_id = H5FD_register_driver_by_name(driver_env_var, true)) < 0)
                    HGOTO_ERROR(H5E_VFL, H5E_CANTREGISTER, FAIL, "can't register VFL driver");
                driver_ref_inc = true;
            } 
        }     

        
        driver_config_env_var = getenv(HDF5_DRIVER_CONFIG);

        driver_prop.driver_id         = driver_id;
        driver_prop.driver_info       = NULL;
        driver_prop.driver_config_str = driver_config_env_var;

        
        if (NULL == (def_fapclass = (H5P_genclass_t *)H5I_object(H5P_FILE_ACCESS)))
            HGOTO_ERROR(H5E_VFL, H5E_BADID, FAIL,
                        "can't find object for default file access property class ID");

        
        if (H5P__class_set(def_fapclass, H5F_ACS_FILE_DRV_NAME, &driver_prop) < 0)
            HGOTO_ERROR(H5E_VFL, H5E_CANTSET, FAIL,
                        "can't set default VFL driver for default file access property list class");

        
        if (NULL == (def_fapl = (H5P_genplist_t *)H5I_object(H5P_FILE_ACCESS_DEFAULT)))
            HGOTO_ERROR(H5E_VFL, H5E_BADID, FAIL, "can't find object for default fapl ID");

        
        if (H5P_set_driver(def_fapl, driver_prop.driver_id, driver_prop.driver_info,
                           driver_prop.driver_config_str) < 0)
            HGOTO_ERROR(H5E_VFL, H5E_CANTSET, FAIL, "can't set default VFL driver for default FAPL");
    }

done:
    
    if (ret_value < 0) {
        if (driver_id >= 0 && driver_ref_inc && H5I_dec_app_ref(driver_id) < 0)
            HDONE_ERROR(H5E_PLIST, H5E_CANTDEC, FAIL, "unable to unregister VFL driver");
    } 

    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_set_def_driver_check_predefined(const char *driver_name, hid_t *driver_id)
{
    herr_t ret_value = SUCCEED;

    FUNC_ENTER_PACKAGE

    assert(driver_name);
    assert(driver_id);

    if (!strcmp(driver_name, "sec2")) {
        if ((*driver_id = H5FD_SEC2) < 0)
            HGOTO_ERROR(H5E_VFL, H5E_UNINITIALIZED, FAIL, "couldn't initialize sec2 VFD");
    }
    else if (!strcmp(driver_name, "core") || !strcmp(driver_name, "core_paged")) {
        if ((*driver_id = H5FD_CORE) < 0)
            HGOTO_ERROR(H5E_VFL, H5E_UNINITIALIZED, FAIL, "couldn't initialize core VFD");
    }
    else if (!strcmp(driver_name, "log")) {
        if ((*driver_id = H5FD_LOG) < 0)
            HGOTO_ERROR(H5E_VFL, H5E_UNINITIALIZED, FAIL, "couldn't initialize log VFD");
    }
    else if (!strcmp(driver_name, "family")) {
        if ((*driver_id = H5FD_FAMILY) < 0)
            HGOTO_ERROR(H5E_VFL, H5E_UNINITIALIZED, FAIL, "couldn't initialize family VFD");
    }
    else if (!strcmp(driver_name, "multi") || !strcmp(driver_name, "split")) {
        if ((*driver_id = H5FD_MULTI) < 0)
            HGOTO_ERROR(H5E_VFL, H5E_UNINITIALIZED, FAIL, "couldn't initialize multi VFD");
    }
    else if (!strcmp(driver_name, "stdio")) {
        if ((*driver_id = H5FD_STDIO) < 0)
            HGOTO_ERROR(H5E_VFL, H5E_UNINITIALIZED, FAIL, "couldn't initialize stdio VFD");
    }
    else if (!strcmp(driver_name, "splitter")) {
        if ((*driver_id = H5FD_SPLITTER) < 0)
            HGOTO_ERROR(H5E_VFL, H5E_UNINITIALIZED, FAIL, "couldn't initialize splitter VFD");
    }
    else if (!strcmp(driver_name, "mpio")) {
#ifdef H5_HAVE_PARALLEL
        if ((*driver_id = H5FD_MPIO) < 0)
            HGOTO_ERROR(H5E_VFL, H5E_UNINITIALIZED, FAIL, "couldn't initialize MPI I/O VFD");
#else
        HGOTO_ERROR(H5E_VFL, H5E_BADVALUE, FAIL, "MPI-I/O VFD is not enabled");
#endif
    }
    else if (!strcmp(driver_name, "direct")) {
#ifdef H5_HAVE_DIRECT
        if ((*driver_id = H5FD_DIRECT) < 0)
            HGOTO_ERROR(H5E_VFL, H5E_UNINITIALIZED, FAIL, "couldn't initialize Direct I/O VFD");
#else
        HGOTO_ERROR(H5E_VFL, H5E_BADVALUE, FAIL, "Direct I/O VFD is not enabled");
#endif
    }
    else if (!strcmp(driver_name, "mirror")) {
#ifdef H5_HAVE_MIRROR_VFD
        if ((*driver_id = H5FD_MIRROR) < 0)
            HGOTO_ERROR(H5E_VFL, H5E_UNINITIALIZED, FAIL, "couldn't initialize mirror VFD");
#else
        HGOTO_ERROR(H5E_VFL, H5E_BADVALUE, FAIL, "Mirror VFD is not enabled");
#endif
    }
    else if (!strcmp(driver_name, "hdfs")) {
#ifdef H5_HAVE_LIBHDFS
        if ((*driver_id = H5FD_HDFS) < 0)
            HGOTO_ERROR(H5E_VFL, H5E_UNINITIALIZED, FAIL, "couldn't initialize HDFS VFD");
#else
        HGOTO_ERROR(H5E_VFL, H5E_BADVALUE, FAIL, "HDFS VFD is not enabled");
#endif
    }
    else if (!strcmp(driver_name, "ros3")) {
#ifdef H5_HAVE_ROS3_VFD
        if ((*driver_id = H5FD_ROS3) < 0)
            HGOTO_ERROR(H5E_VFL, H5E_UNINITIALIZED, FAIL, "couldn't initialize ROS3 VFD");
#else
        HGOTO_ERROR(H5E_VFL, H5E_BADVALUE, FAIL, "ROS3 VFD is not enabled");
#endif
    }
    else if (!strcmp(driver_name, "subfiling")) {
#ifdef H5_HAVE_SUBFILING_VFD
        if ((*driver_id = H5FD_SUBFILING) < 0)
            HGOTO_ERROR(H5E_VFL, H5E_UNINITIALIZED, FAIL, "couldn't initialize Subfiling VFD");
#else
        HGOTO_ERROR(H5E_VFL, H5E_BADVALUE, FAIL, "Subfiling VFD is not enabled");
#endif
    }
    else if (!strcmp(driver_name, "windows")) {
#ifdef H5_HAVE_WINDOWS
        if ((*driver_id = H5FD_WINDOWS) < 0)
            HGOTO_ERROR(H5E_VFL, H5E_UNINITIALIZED, FAIL, "couldn't initialize Windows VFD");
#else
        HGOTO_ERROR(H5E_VFL, H5E_BADVALUE, FAIL, "Windows VFD is not enabled");
#endif
    }
    else {
        *driver_id = H5I_INVALID_HID;
    }

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5Pset_alignment(hid_t fapl_id, hsize_t threshold, hsize_t alignment)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (alignment < 1)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "alignment must be positive");

    
    if (NULL == (plist = H5P_object_verify(fapl_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_set(plist, H5F_ACS_ALIGN_THRHD_NAME, &threshold) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set threshold");
    if (H5P_set(plist, H5F_ACS_ALIGN_NAME, &alignment) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set alignment");

done:
    FUNC_LEAVE_API(ret_value)
}

herr_t
H5Pget_alignment(hid_t fapl_id, hsize_t *threshold , hsize_t *alignment )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(fapl_id, H5P_FILE_ACCESS, true)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (threshold)
        if (H5P_get(plist, H5F_ACS_ALIGN_THRHD_NAME, threshold) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get threshold");
    if (alignment)
        if (H5P_get(plist, H5F_ACS_ALIGN_NAME, alignment) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get alignment");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5P_set_driver(H5P_genplist_t *plist, hid_t new_driver_id, const void *new_driver_info,
               const char *new_driver_config_str)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_NOAPI(FAIL)

    
    assert(!new_driver_info || !new_driver_config_str);

    if (NULL == H5I_object_verify(new_driver_id, H5I_VFL))
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a file driver ID");

    if (true == H5P_isa_class(plist->plist_id, H5P_FILE_ACCESS)) {
        H5FD_driver_prop_t driver_prop; 

        
        driver_prop.driver_id         = new_driver_id;
        driver_prop.driver_info       = new_driver_info;
        driver_prop.driver_config_str = new_driver_config_str;

        
        if (H5P_set(plist, H5F_ACS_FILE_DRV_NAME, &driver_prop) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set driver ID & info");
    } 
    else
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a file access property list");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5Pset_driver(hid_t plist_id, hid_t new_driver_id, const void *new_driver_info)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = (H5P_genplist_t *)H5I_object_verify(plist_id, H5I_GENPROP_LST)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a property list");
    if (NULL == H5I_object_verify(new_driver_id, H5I_VFL))
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a file driver ID");

    
    if (H5P_set_driver(plist, new_driver_id, new_driver_info, NULL) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set driver info");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5P_set_driver_by_name(H5P_genplist_t *plist, const char *driver_name, const char *driver_config,
                       bool app_ref)
{
    hid_t  new_driver_id = H5I_INVALID_HID;
    herr_t ret_value     = SUCCEED;

    FUNC_ENTER_NOAPI(FAIL)

    assert(plist);
    assert(driver_name);

    
    if ((new_driver_id = H5FD_register_driver_by_name(driver_name, app_ref)) < 0)
        HGOTO_ERROR(H5E_VFL, H5E_CANTREGISTER, FAIL, "unable to register VFD");

    
    if (H5P_set_driver(plist, new_driver_id, NULL, driver_config) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set driver info");

done:
    if (ret_value < 0) {
        if (new_driver_id >= 0 && H5I_dec_app_ref(new_driver_id) < 0)
            HDONE_ERROR(H5E_PLIST, H5E_CANTDEC, FAIL, "can't decrement count on VFD ID");
    }

    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5Pset_driver_by_name(hid_t plist_id, const char *driver_name, const char *driver_config)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = (H5P_genplist_t *)H5I_object_verify(plist_id, H5I_GENPROP_LST)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a property list");
    if (!driver_name)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "driver_name parameter cannot be NULL");
    if (!*driver_name)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "driver_name parameter cannot be an empty string");

    
    if (H5P_set_driver_by_name(plist, driver_name, driver_config, true) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set driver info");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5P_set_driver_by_value(H5P_genplist_t *plist, H5FD_class_value_t driver_value, const char *driver_config,
                        bool app_ref)
{
    hid_t  new_driver_id = H5I_INVALID_HID;
    herr_t ret_value     = SUCCEED;

    FUNC_ENTER_NOAPI(FAIL)

    assert(plist);
    assert(driver_value >= 0);

    
    if ((new_driver_id = H5FD_register_driver_by_value(driver_value, app_ref)) < 0)
        HGOTO_ERROR(H5E_VFL, H5E_CANTREGISTER, FAIL, "unable to register VFD");

    
    if (H5P_set_driver(plist, new_driver_id, NULL, driver_config) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set driver info");

done:
    if (ret_value < 0) {
        if (new_driver_id >= 0 && H5I_dec_app_ref(new_driver_id) < 0)
            HDONE_ERROR(H5E_PLIST, H5E_CANTDEC, FAIL, "can't decrement count on VFD ID");
    }

    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5Pset_driver_by_value(hid_t plist_id, H5FD_class_value_t driver_value, const char *driver_config)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = (H5P_genplist_t *)H5I_object_verify(plist_id, H5I_GENPROP_LST)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a property list");
    if (driver_value < 0)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "negative VFD value is disallowed");

    
    if (H5P_set_driver_by_value(plist, driver_value, driver_config, true) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set driver info");

done:
    FUNC_LEAVE_API(ret_value)
} 

hid_t
H5P_peek_driver(H5P_genplist_t *plist)
{
    hid_t ret_value = FAIL; 

    FUNC_ENTER_NOAPI(FAIL)

    
    if (true == H5P_isa_class(plist->plist_id, H5P_FILE_ACCESS)) {
        H5FD_driver_prop_t driver_prop; 

        if (H5P_peek(plist, H5F_ACS_FILE_DRV_NAME, &driver_prop) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get driver ID");
        ret_value = driver_prop.driver_id;
    } 
    else
        HGOTO_ERROR(H5E_PLIST, H5E_BADTYPE, FAIL, "not a file access property list");

    if (H5FD_VFD_DEFAULT == ret_value)
        ret_value = H5_DEFAULT_VFD;

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

hid_t
H5Pget_driver(hid_t plist_id)
{
    H5P_genplist_t *plist;     
    hid_t           ret_value; 

    FUNC_ENTER_API(H5I_INVALID_HID)

    if (NULL == (plist = (H5P_genplist_t *)H5I_object_verify(plist_id, H5I_GENPROP_LST)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, H5I_INVALID_HID, "not a property list");

    
    if ((ret_value = H5P_peek_driver(plist)) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, H5I_INVALID_HID, "can't get driver");

done:
    FUNC_LEAVE_API(ret_value)
} 

const void *
H5P_peek_driver_info(H5P_genplist_t *plist)
{
    const void *ret_value = NULL;

    FUNC_ENTER_NOAPI(NULL)

    
    if (true == H5P_isa_class(plist->plist_id, H5P_FILE_ACCESS)) {
        H5FD_driver_prop_t driver_prop; 

        if (H5P_peek(plist, H5F_ACS_FILE_DRV_NAME, &driver_prop) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, NULL, "can't get driver info");
        ret_value = driver_prop.driver_info;
    }
    else
        HGOTO_ERROR(H5E_PLIST, H5E_BADTYPE, NULL, "not a file access property list");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

const void *
H5Pget_driver_info(hid_t plist_id)
{
    H5P_genplist_t *plist     = NULL; 
    const void     *ret_value = NULL; 

    FUNC_ENTER_API(NULL)

    if (NULL == (plist = (H5P_genplist_t *)H5I_object_verify(plist_id, H5I_GENPROP_LST)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, NULL, "not a property list");

    
    if (NULL == (ret_value = (const void *)H5P_peek_driver_info(plist)))
        HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, NULL, "can't get driver info");

done:
    FUNC_LEAVE_API(ret_value)
} 

const char *
H5P_peek_driver_config_str(H5P_genplist_t *plist)
{
    const char *ret_value = NULL; 

    FUNC_ENTER_NOAPI(NULL)

    
    if (true == H5P_isa_class(plist->plist_id, H5P_FILE_ACCESS)) {
        H5FD_driver_prop_t driver_prop; 

        if (H5P_peek(plist, H5F_ACS_FILE_DRV_NAME, &driver_prop) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, NULL, "can't get driver configuration string");
        ret_value = driver_prop.driver_config_str;
    } 
    else
        HGOTO_ERROR(H5E_PLIST, H5E_BADTYPE, NULL, "not a file access property list");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

ssize_t
H5Pget_driver_config_str(hid_t fapl_id, char *config_buf, size_t buf_size)
{
    H5P_genplist_t *plist; 
    const char     *config_str = NULL;
    ssize_t         ret_value  = -1;

    FUNC_ENTER_API((-1))

    
    if (!config_buf && buf_size)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, (-1), "config_buf cannot be NULL if buf_size is non-zero");

    
    if (NULL == (plist = H5P_object_verify(fapl_id, H5P_FILE_ACCESS, true)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, (-1), "can't find object for ID");

    
    if ((config_str = H5P_peek_driver_config_str(plist))) {
        size_t config_str_len = strlen(config_str);

        if (config_buf) {
            strncpy(config_buf, config_str, buf_size);
            if (config_str_len >= buf_size)
                config_buf[buf_size - 1] = '\0';
        }

        ret_value = (ssize_t)config_str_len;
    }
    else
        ret_value = 0;

done:
    FUNC_LEAVE_API(ret_value)
} 

static herr_t
H5P__file_driver_copy(void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    if (value) {
        H5FD_driver_prop_t *info = (H5FD_driver_prop_t *)value; 

        
        if (info->driver_id > 0) {
            
            if (H5I_inc_ref(info->driver_id, false) < 0)
                HGOTO_ERROR(H5E_PLIST, H5E_CANTINC, FAIL, "unable to increment ref count on VFL driver");

            
            if (info->driver_info) {
                H5FD_class_t *driver; 
                void         *new_pl; 

                
                if (NULL == (driver = (H5FD_class_t *)H5I_object(info->driver_id)))
                    HGOTO_ERROR(H5E_PLIST, H5E_BADTYPE, FAIL, "not a driver ID");

                
                if (driver->fapl_copy) {
                    if (NULL == (new_pl = (driver->fapl_copy)(info->driver_info)))
                        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "driver info copy failed");
                } 
                else if (driver->fapl_size > 0) {
                    if (NULL == (new_pl = H5MM_malloc(driver->fapl_size)))
                        HGOTO_ERROR(H5E_PLIST, H5E_CANTALLOC, FAIL, "driver info allocation failed");
                    H5MM_memcpy(new_pl, info->driver_info, driver->fapl_size);
                } 
                else
                    HGOTO_ERROR(H5E_PLIST, H5E_UNSUPPORTED, FAIL, "no way to copy driver info");

                
                info->driver_info = new_pl;
            } 

            
            if (info->driver_config_str) {
                char *new_config_str = NULL;

                if (NULL == (new_config_str = H5MM_strdup(info->driver_config_str)))
                    HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "driver configuration string copy failed");
                info->driver_config_str = new_config_str;
            } 
        }     
    }         

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__file_driver_free(void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    if (value) {
        H5FD_driver_prop_t *info = (H5FD_driver_prop_t *)value; 

        if (info->driver_id > 0) {

            
            if (info->driver_info)
                if (H5FD_free_driver_info(info->driver_id, info->driver_info) < 0)
                    HGOTO_ERROR(H5E_PLIST, H5E_CANTFREE, FAIL, "driver info free request failed");

            
            H5MM_xfree_const(info->driver_config_str);

            
            if (H5I_dec_ref(info->driver_id) < 0)
                HGOTO_ERROR(H5E_PLIST, H5E_CANTDEC, FAIL, "can't decrement reference count for driver ID");
        }
    }

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_file_driver_create(const char H5_ATTR_UNUSED *name, size_t H5_ATTR_UNUSED size, void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (H5P__file_driver_copy(value) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "can't copy file driver");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_file_driver_set(hid_t H5_ATTR_UNUSED prop_id, const char H5_ATTR_UNUSED *name,
                          size_t H5_ATTR_UNUSED size, void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    assert(value);

    
    if (H5P__file_driver_copy(value) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "can't copy file driver");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_file_driver_get(hid_t H5_ATTR_UNUSED prop_id, const char H5_ATTR_UNUSED *name,
                          size_t H5_ATTR_UNUSED size, void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    assert(value);

    
    if (H5P__file_driver_copy(value) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "can't copy file driver");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_file_driver_del(hid_t H5_ATTR_UNUSED prop_id, const char H5_ATTR_UNUSED *name,
                          size_t H5_ATTR_UNUSED size, void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (H5P__file_driver_free(value) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTRELEASE, FAIL, "can't release file driver");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_file_driver_copy(const char H5_ATTR_UNUSED *name, size_t H5_ATTR_UNUSED size, void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (H5P__file_driver_copy(value) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "can't copy file driver");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static int
H5P__facc_file_driver_cmp(const void *_info1, const void *_info2, size_t H5_ATTR_UNUSED size)
{
    const H5FD_driver_prop_t *info1 =
                                 (const H5FD_driver_prop_t *)_info1, 
        *info2 = (const H5FD_driver_prop_t *)_info2;
    H5FD_class_t *cls1, *cls2;   
    int           cmp_value;     
    herr_t        ret_value = 0; 

    FUNC_ENTER_PACKAGE_NOERR

    
    assert(info1);
    assert(info2);
    assert(size == sizeof(H5FD_driver_prop_t));

    
    if (NULL == (cls1 = H5FD_get_class(info1->driver_id)))
        HGOTO_DONE(-1);
    if (NULL == (cls2 = H5FD_get_class(info2->driver_id)))
        HGOTO_DONE(1);
    if (cls1->name == NULL && cls2->name != NULL)
        HGOTO_DONE(-1);
    if (cls1->name != NULL && cls2->name == NULL)
        HGOTO_DONE(1);
    if (0 != (cmp_value = strcmp(cls1->name, cls2->name)))
        HGOTO_DONE(cmp_value);

    
    if (cls1->fapl_size < cls2->fapl_size)
        HGOTO_DONE(-1);
    if (cls1->fapl_size > cls2->fapl_size)
        HGOTO_DONE(1);
    assert(cls1->fapl_size == cls2->fapl_size);
    if (info1->driver_info == NULL && info2->driver_info != NULL)
        HGOTO_DONE(-1);
    if (info1->driver_info != NULL && info2->driver_info == NULL)
        HGOTO_DONE(1);
    if (info1->driver_info) {
        assert(cls1->fapl_size > 0);
        if (0 != (cmp_value = memcmp(info1->driver_info, info2->driver_info, cls1->fapl_size)))
            HGOTO_DONE(cmp_value);
    } 

    
    if (info1->driver_config_str == NULL && info2->driver_config_str != NULL)
        HGOTO_DONE(-1);
    if (info1->driver_config_str != NULL && info2->driver_config_str == NULL)
        HGOTO_DONE(1);
    if (info1->driver_config_str) {
        if (0 != (cmp_value = strcmp(info1->driver_config_str, info2->driver_config_str)))
            HGOTO_DONE(cmp_value);
    }

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_file_driver_close(const char H5_ATTR_UNUSED *name, size_t H5_ATTR_UNUSED size, void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (H5P__file_driver_free(value) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTRELEASE, FAIL, "can't release file driver");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5Pset_family_offset(hid_t fapl_id, hsize_t offset)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (H5P_DEFAULT == fapl_id)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "can't modify default property list");
    if (NULL == (plist = H5P_object_verify(fapl_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_set(plist, H5F_ACS_FAMILY_OFFSET_NAME, &offset) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set offset for family file");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_family_offset(hid_t fapl_id, hsize_t *offset )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (H5P_DEFAULT == fapl_id)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "can't modify default property list");
    if (NULL == (plist = H5P_object_verify(fapl_id, H5P_FILE_ACCESS, true)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (offset) {
        if (H5P_get(plist, H5F_ACS_FAMILY_OFFSET_NAME, offset) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't set offset for family file");
    } 

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pset_multi_type(hid_t fapl_id, H5FD_mem_t type)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (H5P_DEFAULT == fapl_id)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "can't modify default property list");
    if (NULL == (plist = H5P_object_verify(fapl_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_set(plist, H5F_ACS_MULTI_TYPE_NAME, &type) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set type for multi driver");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_multi_type(hid_t fapl_id, H5FD_mem_t *type )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (H5P_DEFAULT == fapl_id)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "can't modify default property list");
    if (NULL == (plist = H5P_object_verify(fapl_id, H5P_FILE_ACCESS, true)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (type) {
        if (H5P_get(plist, H5F_ACS_MULTI_TYPE_NAME, type) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get type for multi driver");
    } 

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pset_cache(hid_t plist_id, int H5_ATTR_UNUSED mdc_nelmts, size_t rdcc_nslots, size_t rdcc_nbytes,
             double rdcc_w0)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (rdcc_w0 < 0.0 || rdcc_w0 > 1.0)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL,
                    "raw data cache w0 value must be between 0.0 and 1.0 inclusive");

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_set(plist, H5F_ACS_DATA_CACHE_NUM_SLOTS_NAME, &rdcc_nslots) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set data cache number of slots");
    if (H5P_set(plist, H5F_ACS_DATA_CACHE_BYTE_SIZE_NAME, &rdcc_nbytes) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set data cache byte size");
    if (H5P_set(plist, H5F_ACS_PREEMPT_READ_CHUNKS_NAME, &rdcc_w0) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set preempt read chunks");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_cache(hid_t plist_id, int *mdc_nelmts, size_t *rdcc_nslots , size_t *rdcc_nbytes ,
             double *rdcc_w0 )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, true)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    

    
    if (mdc_nelmts)
        *mdc_nelmts = 0;

    if (rdcc_nslots)
        if (H5P_get(plist, H5F_ACS_DATA_CACHE_NUM_SLOTS_NAME, rdcc_nslots) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get data cache number of slots");
    if (rdcc_nbytes)
        if (H5P_get(plist, H5F_ACS_DATA_CACHE_BYTE_SIZE_NAME, rdcc_nbytes) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get data cache byte size");
    if (rdcc_w0)
        if (H5P_get(plist, H5F_ACS_PREEMPT_READ_CHUNKS_NAME, rdcc_w0) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get preempt read chunks");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pset_mdc_image_config(hid_t plist_id, H5AC_cache_image_config_t *config_ptr)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5AC_validate_cache_image_config(config_ptr) < 0)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "invalid metadata cache image configuration");

    

    

    if (H5P_set(plist, H5F_ACS_META_CACHE_INIT_IMAGE_CONFIG_NAME, config_ptr) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set metadata cache image initial config");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_mdc_image_config(hid_t plist_id, H5AC_cache_image_config_t *config )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, true)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (config == NULL)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "NULL config ptr on entry.");
    if (config->version != H5AC__CURR_CACHE_IMAGE_CONFIG_VERSION)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "Unknown image config version.");

    

    
    if (H5P_get(plist, H5F_ACS_META_CACHE_INIT_IMAGE_CONFIG_NAME, config) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get metadata cache initial image config");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pset_mdc_config(hid_t plist_id, H5AC_cache_config_t *config_ptr)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5AC_validate_config(config_ptr) < 0)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "invalid metadata cache configuration");

    

    

    if (H5P_set(plist, H5F_ACS_META_CACHE_INIT_CONFIG_NAME, config_ptr) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set metadata cache initial config");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_mdc_config(hid_t plist_id, H5AC_cache_config_t *config )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, true)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (config == NULL)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "NULL config ptr on entry.");
    if (config->version != H5AC__CURR_CACHE_CONFIG_VERSION)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "Unknown config version.");

    

    
    if (H5P_get(plist, H5F_ACS_META_CACHE_INIT_CONFIG_NAME, config) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get metadata cache initial resize config");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pset_gc_references(hid_t plist_id, unsigned gc_ref)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_set(plist, H5F_ACS_GARBG_COLCT_REF_NAME, &gc_ref) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set garbage collect reference");

done:
    FUNC_LEAVE_API(ret_value)
}

herr_t
H5Pget_gc_references(hid_t plist_id, unsigned *gc_ref )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, true)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (gc_ref)
        if (H5P_get(plist, H5F_ACS_GARBG_COLCT_REF_NAME, gc_ref) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get garbage collect reference");

done:
    FUNC_LEAVE_API(ret_value)
}

herr_t
H5Pset_fclose_degree(hid_t plist_id, H5F_close_degree_t degree)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_set(plist, H5F_ACS_CLOSE_DEGREE_NAME, &degree) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set file close degree");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_fclose_degree(hid_t plist_id, H5F_close_degree_t *degree )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, true)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    if (degree && H5P_get(plist, H5F_ACS_CLOSE_DEGREE_NAME, degree) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get file close degree");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pset_meta_block_size(hid_t plist_id, hsize_t size)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_set(plist, H5F_ACS_META_BLOCK_SIZE_NAME, &size) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set meta data block size");

done:
    FUNC_LEAVE_API(ret_value)
}

herr_t
H5Pget_meta_block_size(hid_t plist_id, hsize_t *size )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, true)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (size) {
        if (H5P_get(plist, H5F_ACS_META_BLOCK_SIZE_NAME, size) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get meta data block size");
    } 

done:
    FUNC_LEAVE_API(ret_value)
}

herr_t
H5Pset_sieve_buf_size(hid_t plist_id, size_t size)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_set(plist, H5F_ACS_SIEVE_BUF_SIZE_NAME, &size) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set sieve buffer size");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_sieve_buf_size(hid_t plist_id, size_t *size )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, true)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (size)
        if (H5P_get(plist, H5F_ACS_SIEVE_BUF_SIZE_NAME, size) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get sieve buffer size");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pset_small_data_block_size(hid_t plist_id, hsize_t size)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_set(plist, H5F_ACS_SDATA_BLOCK_SIZE_NAME, &size) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set 'small data' block size");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_small_data_block_size(hid_t plist_id, hsize_t *size )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, true)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (size) {
        if (H5P_get(plist, H5F_ACS_SDATA_BLOCK_SIZE_NAME, size) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get 'small data' block size");
    } 

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pset_libver_bounds(hid_t plist_id, H5F_libver_t low, H5F_libver_t high)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (low < 0 || low > H5F_LIBVER_LATEST)
        HGOTO_ERROR(H5E_ARGS, H5E_BADRANGE, FAIL, "low bound is not valid");
    if (high < 0 || high > H5F_LIBVER_LATEST)
        HGOTO_ERROR(H5E_ARGS, H5E_BADRANGE, FAIL, "high bound is not valid");

    
    if (high == H5F_LIBVER_EARLIEST)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "Invalid (low,high) combination of library version bound");

    
    if (high < low)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "Invalid (low,high) combination of library version bound");

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_set(plist, H5F_ACS_LIBVER_LOW_BOUND_NAME, &low) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set low bound for library format versions");
    if (H5P_set(plist, H5F_ACS_LIBVER_HIGH_BOUND_NAME, &high) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set high bound for library format versions");
done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_libver_bounds(hid_t plist_id, H5F_libver_t *low , H5F_libver_t *high )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, true)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (low)
        if (H5P_get(plist, H5F_ACS_LIBVER_LOW_BOUND_NAME, low) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get low bound for library format versions");

    if (high)
        if (H5P_get(plist, H5F_ACS_LIBVER_HIGH_BOUND_NAME, high) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get high bound for library format versions");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pset_elink_file_cache_size(hid_t plist_id, unsigned efc_size)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_set(plist, H5F_ACS_EFC_SIZE_NAME, &efc_size) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set elink file cache size");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_elink_file_cache_size(hid_t plist_id, unsigned *efc_size )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, true)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (efc_size)
        if (H5P_get(plist, H5F_ACS_EFC_SIZE_NAME, efc_size) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get elink file cache size");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pset_file_image(hid_t fapl_id, void *buf_ptr, size_t buf_len)
{
    H5P_genplist_t        *fapl;                
    H5FD_file_image_info_t image_info;          
    herr_t                 ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (!(((buf_ptr == NULL) && (buf_len == 0)) || ((buf_ptr != NULL) && (buf_len > 0))))
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "inconsistent buf_ptr and buf_len");

    
    if (NULL == (fapl = H5P_object_verify(fapl_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_PLIST, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_peek(fapl, H5F_ACS_FILE_IMAGE_INFO_NAME, &image_info) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get old file image pointer");

    
    if (image_info.buffer != NULL) {
        if (image_info.callbacks.image_free) {
            
            H5_BEFORE_USER_CB(FAIL)
                {
                    ret_value = image_info.callbacks.image_free(
                        image_info.buffer, H5FD_FILE_IMAGE_OP_PROPERTY_LIST_SET, image_info.callbacks.udata);
                }
            H5_AFTER_USER_CB(FAIL)
            if (ret_value < 0)
                HGOTO_ERROR(H5E_PLIST, H5E_CANTFREE, FAIL, "image_free callback failed");
        } 
        else
            H5MM_xfree(image_info.buffer);
    } 

    
    if (buf_ptr) {
        
        if (image_info.callbacks.image_malloc) {
            
            H5_BEFORE_USER_CB(FAIL)
                {
                    image_info.buffer = image_info.callbacks.image_malloc(
                        buf_len, H5FD_FILE_IMAGE_OP_PROPERTY_LIST_SET, image_info.callbacks.udata);
                }
            H5_AFTER_USER_CB(FAIL)
            if (NULL == image_info.buffer)
                HGOTO_ERROR(H5E_PLIST, H5E_CANTALLOC, FAIL, "image malloc callback failed");
        } 
        else if (NULL == (image_info.buffer = H5MM_malloc(buf_len)))
            HGOTO_ERROR(H5E_PLIST, H5E_CANTALLOC, FAIL, "unable to allocate memory block");

        
        if (image_info.callbacks.image_memcpy) {
            void *tmp;

            
            H5_BEFORE_USER_CB(FAIL)
                {
                    tmp = image_info.callbacks.image_memcpy(image_info.buffer, buf_ptr, buf_len,
                                                            H5FD_FILE_IMAGE_OP_PROPERTY_LIST_SET,
                                                            image_info.callbacks.udata);
                }
            H5_AFTER_USER_CB(FAIL)
            if (image_info.buffer != tmp)
                HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "image_memcpy callback failed");
        } 
        else
            H5MM_memcpy(image_info.buffer, buf_ptr, buf_len);
    } 
    else
        image_info.buffer = NULL;

    image_info.size = buf_len;

    
    if (H5P_poke(fapl, H5F_ACS_FILE_IMAGE_INFO_NAME, &image_info) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set file image info");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_file_image(hid_t fapl_id, void **buf , size_t *buf_len )
{
    H5P_genplist_t        *fapl;                
    H5FD_file_image_info_t image_info;          
    herr_t                 ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (fapl = H5P_object_verify(fapl_id, H5P_FILE_ACCESS, true)))
        HGOTO_ERROR(H5E_PLIST, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_peek(fapl, H5F_ACS_FILE_IMAGE_INFO_NAME, &image_info) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get file image info");

    
    assert(((image_info.buffer != NULL) && (image_info.size > 0)) ||
           ((image_info.buffer == NULL) && (image_info.size == 0)));

    
    if (buf_len != NULL)
        *buf_len = image_info.size;

    
    if (buf != NULL) {
        void *copy_ptr = NULL; 

        if (image_info.buffer != NULL) {
            
            if (image_info.callbacks.image_malloc) {
                
                H5_BEFORE_USER_CB(FAIL)
                    {
                        copy_ptr = image_info.callbacks.image_malloc(image_info.size,
                                                                     H5FD_FILE_IMAGE_OP_PROPERTY_LIST_GET,
                                                                     image_info.callbacks.udata);
                    }
                H5_AFTER_USER_CB(FAIL)
                if (NULL == copy_ptr)
                    HGOTO_ERROR(H5E_PLIST, H5E_CANTALLOC, FAIL, "image malloc callback failed");
            } 
            else if (NULL == (copy_ptr = H5MM_malloc(image_info.size)))
                HGOTO_ERROR(H5E_PLIST, H5E_CANTALLOC, FAIL, "unable to allocate copy");

            
            if (image_info.callbacks.image_memcpy) {
                void *tmp;

                
                H5_BEFORE_USER_CB(FAIL)
                    {
                        tmp = image_info.callbacks.image_memcpy(copy_ptr, image_info.buffer, image_info.size,
                                                                H5FD_FILE_IMAGE_OP_PROPERTY_LIST_GET,
                                                                image_info.callbacks.udata);
                    }
                H5_AFTER_USER_CB(FAIL)
                if (copy_ptr != tmp)
                    HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "image_memcpy callback failed");
            } 
            else
                H5MM_memcpy(copy_ptr, image_info.buffer, image_info.size);
        } 

        *buf = copy_ptr;
    } 

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pset_file_image_callbacks(hid_t fapl_id, H5FD_file_image_callbacks_t *callbacks_ptr)
{
    H5P_genplist_t        *fapl;                   
    H5FD_file_image_info_t info;                   
    bool                   copied_udata = false;   
    herr_t                 ret_value    = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (fapl = H5P_object_verify(fapl_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_PLIST, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_peek(fapl, H5F_ACS_FILE_IMAGE_INFO_NAME, &info) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get old file image info");

    
    assert(((info.buffer != NULL) && (info.size > 0)) || ((info.buffer == NULL) && (info.size == 0)));

    
    if (info.buffer != NULL || info.size > 0)
        HGOTO_ERROR(
            H5E_PLIST, H5E_SETDISALLOWED, FAIL,
            "setting callbacks when an image is already set is forbidden. It could cause memory leaks.");

    
    if (NULL == callbacks_ptr)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "NULL callbacks_ptr");

    
    if (callbacks_ptr->udata)
        if (callbacks_ptr->udata_copy == NULL || callbacks_ptr->udata_free == NULL)
            HGOTO_ERROR(H5E_PLIST, H5E_SETDISALLOWED, FAIL, "udata callbacks must be set if udata is set");

    
    if (info.callbacks.udata != NULL) {
        assert(info.callbacks.udata_free);

        
        H5_BEFORE_USER_CB(FAIL)
            {
                ret_value = info.callbacks.udata_free(info.callbacks.udata);
            }
        H5_AFTER_USER_CB(FAIL)
        if (ret_value < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTFREE, FAIL, "udata_free callback failed");
    } 

    
    info.callbacks = *callbacks_ptr;

    if (callbacks_ptr->udata) {
        assert(callbacks_ptr->udata_copy);
        assert(callbacks_ptr->udata_free);

        
        H5_BEFORE_USER_CB(FAIL)
            {
                info.callbacks.udata = callbacks_ptr->udata_copy(callbacks_ptr->udata);
            }
        H5_AFTER_USER_CB(FAIL)
        if (NULL == info.callbacks.udata)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't copy the supplied udata");
    } 

    copied_udata = true;

    
    if (H5P_poke(fapl, H5F_ACS_FILE_IMAGE_INFO_NAME, &info) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set file image info");

done:
    if (ret_value < 0) {
        if (copied_udata) {
            
            H5_BEFORE_USER_CB(FAIL)
                {
                    ret_value = callbacks_ptr->udata_free(info.callbacks.udata);
                }
            H5_AFTER_USER_CB(FAIL)
            if (ret_value < 0)
                HDONE_ERROR(H5E_PLIST, H5E_CANTFREE, FAIL, "udata_free callback failed");
        }
    }

    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_file_image_callbacks(hid_t fapl_id, H5FD_file_image_callbacks_t *callbacks )
{
    H5P_genplist_t        *fapl;                
    H5FD_file_image_info_t info;                
    herr_t                 ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (fapl = H5P_object_verify(fapl_id, H5P_FILE_ACCESS, true)))
        HGOTO_ERROR(H5E_PLIST, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_peek(fapl, H5F_ACS_FILE_IMAGE_INFO_NAME, &info) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get file image info");

    
    assert(((info.buffer != NULL) && (info.size > 0)) || ((info.buffer == NULL) && (info.size == 0)));

    
    if (NULL == callbacks)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "NULL callbacks ptr");

    
    *callbacks = info.callbacks;

    
    if (info.callbacks.udata != NULL) {
        assert(info.callbacks.udata_copy);

        
        H5_BEFORE_USER_CB(FAIL)
            {
                callbacks->udata = info.callbacks.udata_copy(info.callbacks.udata);
            }
        H5_AFTER_USER_CB(FAIL)
        if (NULL == callbacks->udata)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't copy udata");
    } 

done:
    FUNC_LEAVE_API(ret_value)
} 

static herr_t
H5P__file_image_info_copy(void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    if (value) {
        H5FD_file_image_info_t *info; 

        info = (H5FD_file_image_info_t *)value;

        
        assert(((info->buffer != NULL) && (info->size > 0)) || ((info->buffer == NULL) && (info->size == 0)));

        if (info->buffer && info->size > 0) {
            void *old_buffer; 

            
            old_buffer = info->buffer;

            
            if (info->callbacks.image_malloc) {
                
                H5_BEFORE_USER_CB(FAIL)
                    {
                        info->buffer = info->callbacks.image_malloc(
                            info->size, H5FD_FILE_IMAGE_OP_PROPERTY_LIST_COPY, info->callbacks.udata);
                    }
                H5_AFTER_USER_CB(FAIL)
                if (NULL == info->buffer)
                    HGOTO_ERROR(H5E_PLIST, H5E_CANTALLOC, FAIL, "image malloc callback failed");
            } 
            else if (NULL == (info->buffer = H5MM_malloc(info->size)))
                HGOTO_ERROR(H5E_PLIST, H5E_CANTALLOC, FAIL, "unable to allocate memory block");

            
            if (info->callbacks.image_memcpy) {
                void *tmp;

                
                H5_BEFORE_USER_CB(FAIL)
                    {
                        tmp = info->callbacks.image_memcpy(info->buffer, old_buffer, info->size,
                                                           H5FD_FILE_IMAGE_OP_PROPERTY_LIST_COPY,
                                                           info->callbacks.udata);
                    }
                H5_AFTER_USER_CB(FAIL)
                if (info->buffer != tmp)
                    HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "image_memcpy callback failed");
            } 
            else
                H5MM_memcpy(info->buffer, old_buffer, info->size);
        } 

        
        if (info->callbacks.udata) {
            void *old_udata = info->callbacks.udata;

            if (NULL == info->callbacks.udata_copy)
                HGOTO_ERROR(H5E_PLIST, H5E_BADVALUE, FAIL, "udata_copy not defined");

            
            H5_BEFORE_USER_CB(FAIL)
                {
                    info->callbacks.udata = info->callbacks.udata_copy(old_udata);
                }
            H5_AFTER_USER_CB(FAIL)
        } 
    }     

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__file_image_info_free(void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    if (value) {
        H5FD_file_image_info_t *info; 

        info = (H5FD_file_image_info_t *)value;

        
        assert(((info->buffer != NULL) && (info->size > 0)) || ((info->buffer == NULL) && (info->size == 0)));

        
        if (info->buffer != NULL && info->size > 0) {
            if (info->callbacks.image_free) {
                
                H5_BEFORE_USER_CB(FAIL)
                    {
                        ret_value = (*info->callbacks.image_free)(
                            info->buffer, H5FD_FILE_IMAGE_OP_PROPERTY_LIST_CLOSE, info->callbacks.udata);
                    }
                H5_AFTER_USER_CB(FAIL)
                if (ret_value < 0)
                    HGOTO_ERROR(H5E_PLIST, H5E_CANTFREE, FAIL, "image_free callback failed");
            } 
            else
                H5MM_xfree(info->buffer);
        } 

        
        if (info->callbacks.udata) {
            if (NULL == info->callbacks.udata_free)
                HGOTO_ERROR(H5E_PLIST, H5E_BADVALUE, FAIL, "udata_free not defined");
            
            H5_BEFORE_USER_CB(FAIL)
                {
                    ret_value = (*info->callbacks.udata_free)(info->callbacks.udata);
                }
            H5_AFTER_USER_CB(FAIL)
            if (ret_value < 0)
                HGOTO_ERROR(H5E_PLIST, H5E_CANTFREE, FAIL, "udata_free callback failed");
        } 
    }     

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static int
H5P__facc_cache_image_config_cmp(const void *_config1, const void *_config2, size_t H5_ATTR_UNUSED size)
{
    const H5AC_cache_image_config_t *config1 =
        (const H5AC_cache_image_config_t *)_config1; 
    const H5AC_cache_image_config_t *config2 =
        (const H5AC_cache_image_config_t *)_config2; 
    int ret_value = 0;                               

    FUNC_ENTER_PACKAGE_NOERR

    
    if (config1 == NULL && config2 != NULL)
        HGOTO_DONE(-1);
    if (config1 != NULL && config2 == NULL)
        HGOTO_DONE(1);

    if (config1->version < config2->version)
        HGOTO_DONE(-1);
    if (config1->version > config2->version)
        HGOTO_DONE(1);

    if (config1->generate_image < config2->generate_image)
        HGOTO_DONE(-1);
    if (config1->generate_image > config2->generate_image)
        HGOTO_DONE(1);

    if (config1->save_resize_status < config2->save_resize_status)
        HGOTO_DONE(-1);
    if (config1->save_resize_status > config2->save_resize_status)
        HGOTO_DONE(1);

    if (config1->entry_ageout < config2->entry_ageout)
        HGOTO_DONE(-1);
    if (config1->entry_ageout > config2->entry_ageout)
        HGOTO_DONE(1);

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_cache_image_config_enc(const void *value, void **_pp, size_t *size)
{
    const H5AC_cache_image_config_t *config =
        (const H5AC_cache_image_config_t *)value; 
    uint8_t **pp = (uint8_t **)_pp;

    FUNC_ENTER_PACKAGE_NOERR

    
    assert(value);

    if (NULL != *pp) {
        
        *(*pp)++ = (uint8_t)sizeof(unsigned);

        INT32ENCODE(*pp, (int32_t)config->version);
        H5_ENCODE_UNSIGNED(*pp, config->generate_image);
        H5_ENCODE_UNSIGNED(*pp, config->save_resize_status);
        INT32ENCODE(*pp, (int32_t)config->entry_ageout);
    } 

    
    *size += (1 + (2 * sizeof(unsigned)) + (2 * sizeof(int32_t)));

    FUNC_LEAVE_NOAPI(SUCCEED)
} 

static herr_t
H5P__facc_cache_image_config_dec(const void **_pp, void *_value)
{
    H5AC_cache_image_config_t *config = (H5AC_cache_image_config_t *)_value;
    const uint8_t            **pp     = (const uint8_t **)_pp;
    unsigned                   enc_size;
    herr_t                     ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    assert(pp);
    assert(*pp);
    assert(config);
    HDcompile_assert(sizeof(size_t) <= sizeof(uint64_t));

    
    H5MM_memcpy(config, &H5F_def_mdc_initCacheImageCfg_g, sizeof(H5AC_cache_image_config_t));

    
    enc_size = *(*pp)++;
    if (enc_size != sizeof(unsigned))
        HGOTO_ERROR(H5E_PLIST, H5E_BADVALUE, FAIL, "unsigned value can't be decoded");

    INT32DECODE(*pp, config->version);
    H5_DECODE_UNSIGNED(*pp, config->generate_image);
    H5_DECODE_UNSIGNED(*pp, config->save_resize_status);
    INT32DECODE(*pp, config->entry_ageout);

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_file_image_info_set(hid_t H5_ATTR_UNUSED prop_id, const char H5_ATTR_UNUSED *name,
                              size_t H5_ATTR_UNUSED size, void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    assert(value);

    
    if (H5P__file_image_info_copy(value) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "can't copy file image info");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_file_image_info_get(hid_t H5_ATTR_UNUSED prop_id, const char H5_ATTR_UNUSED *name,
                              size_t H5_ATTR_UNUSED size, void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    assert(value);

    
    if (H5P__file_image_info_copy(value) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "can't copy file image info");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_file_image_info_del(hid_t H5_ATTR_UNUSED prop_id, const char H5_ATTR_UNUSED *name,
                              size_t H5_ATTR_UNUSED size, void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (H5P__file_image_info_free(value) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTRELEASE, FAIL, "can't release file image info");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_file_image_info_copy(const char H5_ATTR_UNUSED *name, size_t H5_ATTR_UNUSED size, void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (H5P__file_image_info_copy(value) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "can't copy file image info");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static int
H5P__facc_file_image_info_cmp(const void *_info1, const void *_info2, size_t H5_ATTR_UNUSED size)
{
    const H5FD_file_image_info_t *info1 = (const H5FD_file_image_info_t *)
                                     _info1, 
        *info2       = (const H5FD_file_image_info_t *)_info2;
    herr_t ret_value = 0; 

    FUNC_ENTER_PACKAGE_NOERR

    
    assert(info1);
    assert(info2);
    assert(size == sizeof(H5FD_file_image_info_t));

    
    if (info1->size < info2->size)
        HGOTO_DONE(-1);
    if (info1->size > info2->size)
        HGOTO_DONE(1);

    
    
    if (info1->callbacks.image_malloc != info2->callbacks.image_malloc)
        HGOTO_DONE(1);
    if (info1->callbacks.image_memcpy != info2->callbacks.image_memcpy)
        HGOTO_DONE(-1);
    if (info1->callbacks.image_realloc != info2->callbacks.image_realloc)
        HGOTO_DONE(1);
    if (info1->callbacks.image_free != info2->callbacks.image_free)
        HGOTO_DONE(-1);
    if (info1->callbacks.udata_copy != info2->callbacks.udata_copy)
        HGOTO_DONE(1);
    if (info1->callbacks.udata_free != info2->callbacks.udata_free)
        HGOTO_DONE(-1);

    
    
    if (info1->callbacks.udata < info2->callbacks.udata)
        HGOTO_DONE(-1);
    if (info1->callbacks.udata > info2->callbacks.udata)
        HGOTO_DONE(1);

    
    if (info1->buffer != NULL && info2->buffer == NULL)
        HGOTO_DONE(-1);
    if (info1->buffer == NULL && info2->buffer != NULL)
        HGOTO_DONE(1);
    if (info1->buffer != NULL && info2->buffer != NULL)
        ret_value = memcmp(info1->buffer, info2->buffer, size);

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_file_image_info_close(const char H5_ATTR_UNUSED *name, size_t H5_ATTR_UNUSED size, void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (H5P__file_image_info_free(value) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTRELEASE, FAIL, "can't release file image info");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static int
H5P__facc_cache_config_cmp(const void *_config1, const void *_config2, size_t H5_ATTR_UNUSED size)
{
    const H5AC_cache_config_t *config1 =
        (const H5AC_cache_config_t *)_config1; 
    const H5AC_cache_config_t *config2 =
        (const H5AC_cache_config_t *)_config2; 
    int ret_value = 0;                         

    FUNC_ENTER_PACKAGE_NOERR

    
    if (config1 == NULL && config2 != NULL)
        HGOTO_DONE(-1);
    if (config1 != NULL && config2 == NULL)
        HGOTO_DONE(1);

    if (config1->version < config2->version)
        HGOTO_DONE(-1);
    if (config1->version > config2->version)
        HGOTO_DONE(1);

    if (config1->rpt_fcn_enabled < config2->rpt_fcn_enabled)
        HGOTO_DONE(-1);
    if (config1->rpt_fcn_enabled > config2->rpt_fcn_enabled)
        HGOTO_DONE(1);

    if (config1->evictions_enabled < config2->evictions_enabled)
        HGOTO_DONE(-1);
    if (config1->evictions_enabled > config2->evictions_enabled)
        HGOTO_DONE(1);

    if (config1->set_initial_size < config2->set_initial_size)
        HGOTO_DONE(-1);
    if (config1->set_initial_size > config2->set_initial_size)
        HGOTO_DONE(1);

    if (config1->initial_size < config2->initial_size)
        HGOTO_DONE(-1);
    if (config1->initial_size > config2->initial_size)
        HGOTO_DONE(1);

    if (config1->min_clean_fraction < config2->min_clean_fraction)
        HGOTO_DONE(-1);
    if (config1->min_clean_fraction > config2->min_clean_fraction)
        HGOTO_DONE(1);

    if (config1->max_size < config2->max_size)
        HGOTO_DONE(-1);
    if (config1->max_size > config2->max_size)
        HGOTO_DONE(1);

    if (config1->min_size < config2->min_size)
        HGOTO_DONE(-1);
    if (config1->min_size > config2->min_size)
        HGOTO_DONE(1);

    if (config1->epoch_length < config2->epoch_length)
        HGOTO_DONE(-1);
    if (config1->epoch_length > config2->epoch_length)
        HGOTO_DONE(1);

    if (config1->incr_mode < config2->incr_mode)
        HGOTO_DONE(-1);
    if (config1->incr_mode > config2->incr_mode)
        HGOTO_DONE(1);

    if (config1->lower_hr_threshold < config2->lower_hr_threshold)
        HGOTO_DONE(-1);
    if (config1->lower_hr_threshold > config2->lower_hr_threshold)
        HGOTO_DONE(1);

    if (config1->increment < config2->increment)
        HGOTO_DONE(-1);
    if (config1->increment > config2->increment)
        HGOTO_DONE(1);

    if (config1->apply_max_increment < config2->apply_max_increment)
        HGOTO_DONE(-1);
    if (config1->apply_max_increment > config2->apply_max_increment)
        HGOTO_DONE(1);

    if (config1->max_increment < config2->max_increment)
        HGOTO_DONE(-1);
    if (config1->max_increment > config2->max_increment)
        HGOTO_DONE(1);

    if (config1->flash_incr_mode < config2->flash_incr_mode)
        HGOTO_DONE(-1);
    if (config1->flash_incr_mode > config2->flash_incr_mode)
        HGOTO_DONE(1);

    if (config1->flash_multiple < config2->flash_multiple)
        HGOTO_DONE(-1);
    if (config1->flash_multiple > config2->flash_multiple)
        HGOTO_DONE(1);

    if (config1->flash_threshold < config2->flash_threshold)
        HGOTO_DONE(-1);
    if (config1->flash_threshold > config2->flash_threshold)
        HGOTO_DONE(1);

    if (config1->decr_mode < config2->decr_mode)
        HGOTO_DONE(-1);
    if (config1->decr_mode > config2->decr_mode)
        HGOTO_DONE(1);

    if (config1->upper_hr_threshold < config2->upper_hr_threshold)
        HGOTO_DONE(-1);
    if (config1->upper_hr_threshold > config2->upper_hr_threshold)
        HGOTO_DONE(1);

    if (config1->decrement < config2->decrement)
        HGOTO_DONE(-1);
    if (config1->decrement > config2->decrement)
        HGOTO_DONE(1);

    if (config1->apply_max_decrement < config2->apply_max_decrement)
        HGOTO_DONE(-1);
    if (config1->apply_max_decrement > config2->apply_max_decrement)
        HGOTO_DONE(1);

    if (config1->max_decrement < config2->max_decrement)
        HGOTO_DONE(-1);
    if (config1->max_decrement > config2->max_decrement)
        HGOTO_DONE(1);

    if (config1->epochs_before_eviction < config2->epochs_before_eviction)
        HGOTO_DONE(-1);
    if (config1->epochs_before_eviction > config2->epochs_before_eviction)
        HGOTO_DONE(1);

    if (config1->apply_empty_reserve < config2->apply_empty_reserve)
        HGOTO_DONE(-1);
    if (config1->apply_empty_reserve > config2->apply_empty_reserve)
        HGOTO_DONE(1);

    if (config1->empty_reserve < config2->empty_reserve)
        HGOTO_DONE(-1);
    if (config1->empty_reserve > config2->empty_reserve)
        HGOTO_DONE(1);

    if (config1->dirty_bytes_threshold < config2->dirty_bytes_threshold)
        HGOTO_DONE(-1);
    if (config1->dirty_bytes_threshold > config2->dirty_bytes_threshold)
        HGOTO_DONE(1);

    if (config1->metadata_write_strategy < config2->metadata_write_strategy)
        HGOTO_DONE(-1);
    if (config1->metadata_write_strategy > config2->metadata_write_strategy)
        HGOTO_DONE(1);

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_cache_config_enc(const void *value, void **_pp, size_t *size)
{
    const H5AC_cache_config_t *config =
        (const H5AC_cache_config_t *)value; 
    uint8_t **pp = (uint8_t **)_pp;
    unsigned  enc_size;  
    uint64_t  enc_value; 

    FUNC_ENTER_PACKAGE_NOERR

    
    assert(value);
    HDcompile_assert(sizeof(size_t) <= sizeof(uint64_t));

    if (NULL != *pp) {
        
        *(*pp)++ = (uint8_t)sizeof(unsigned);
        *(*pp)++ = (uint8_t)sizeof(double);

        
        INT32ENCODE(*pp, (int32_t)config->version);

        H5_ENCODE_UNSIGNED(*pp, config->rpt_fcn_enabled);

        H5_ENCODE_UNSIGNED(*pp, config->open_trace_file);

        H5_ENCODE_UNSIGNED(*pp, config->close_trace_file);

        H5MM_memcpy(*pp, (const uint8_t *)(config->trace_file_name),
                    (size_t)(H5AC__MAX_TRACE_FILE_NAME_LEN + 1));
        *pp += H5AC__MAX_TRACE_FILE_NAME_LEN + 1;

        H5_ENCODE_UNSIGNED(*pp, config->evictions_enabled);

        H5_ENCODE_UNSIGNED(*pp, config->set_initial_size);

        enc_value = (uint64_t)config->initial_size;
        enc_size  = H5VM_limit_enc_size(enc_value);
        assert(enc_size < 256);
        *(*pp)++ = (uint8_t)enc_size;
        UINT64ENCODE_VAR(*pp, enc_value, enc_size);

        H5_ENCODE_DOUBLE(*pp, config->min_clean_fraction);

        enc_value = (uint64_t)config->max_size;
        enc_size  = H5VM_limit_enc_size(enc_value);
        assert(enc_size < 256);
        *(*pp)++ = (uint8_t)enc_size;
        UINT64ENCODE_VAR(*pp, enc_value, enc_size);

        enc_value = (uint64_t)config->min_size;
        enc_size  = H5VM_limit_enc_size(enc_value);
        assert(enc_size < 256);
        *(*pp)++ = (uint8_t)enc_size;
        UINT64ENCODE_VAR(*pp, enc_value, enc_size);

        
        INT64ENCODE(*pp, (int64_t)config->epoch_length);

        
        *(*pp)++ = (uint8_t)config->incr_mode;

        H5_ENCODE_DOUBLE(*pp, config->lower_hr_threshold);

        H5_ENCODE_DOUBLE(*pp, config->increment);

        H5_ENCODE_UNSIGNED(*pp, config->apply_max_increment);

        enc_value = (uint64_t)config->max_increment;
        enc_size  = H5VM_limit_enc_size(enc_value);
        assert(enc_size < 256);
        *(*pp)++ = (uint8_t)enc_size;
        UINT64ENCODE_VAR(*pp, enc_value, enc_size);

        
        *(*pp)++ = (uint8_t)config->flash_incr_mode;

        H5_ENCODE_DOUBLE(*pp, config->flash_multiple);

        H5_ENCODE_DOUBLE(*pp, config->flash_threshold);

        
        *(*pp)++ = (uint8_t)config->decr_mode;

        H5_ENCODE_DOUBLE(*pp, config->upper_hr_threshold);

        H5_ENCODE_DOUBLE(*pp, config->decrement);

        H5_ENCODE_UNSIGNED(*pp, config->apply_max_decrement);

        enc_value = (uint64_t)config->max_decrement;
        enc_size  = H5VM_limit_enc_size(enc_value);
        assert(enc_size < 256);
        *(*pp)++ = (uint8_t)enc_size;
        UINT64ENCODE_VAR(*pp, enc_value, enc_size);

        
        INT32ENCODE(*pp, (int32_t)config->epochs_before_eviction);

        H5_ENCODE_UNSIGNED(*pp, config->apply_empty_reserve);

        H5_ENCODE_DOUBLE(*pp, config->empty_reserve);

        
        UINT32ENCODE(*pp, (uint32_t)config->dirty_bytes_threshold);

        
        INT32ENCODE(*pp, (int32_t)config->metadata_write_strategy);
    } 

    
    enc_value = (uint64_t)config->initial_size;
    *size += 1 + H5VM_limit_enc_size(enc_value);
    enc_value = (uint64_t)config->max_size;
    *size += 1 + H5VM_limit_enc_size(enc_value);
    enc_value = (uint64_t)config->min_size;
    *size += 1 + H5VM_limit_enc_size(enc_value);
    enc_value = (uint64_t)config->max_increment;
    *size += 1 + H5VM_limit_enc_size(enc_value);
    enc_value = (uint64_t)config->max_decrement;
    *size += 1 + H5VM_limit_enc_size(enc_value);

    
    *size += (5 + (sizeof(unsigned) * 8) + (sizeof(double) * 8) + (sizeof(int32_t) * 4) + sizeof(int64_t) +
              H5AC__MAX_TRACE_FILE_NAME_LEN + 1);

    FUNC_LEAVE_NOAPI(SUCCEED)
} 

static herr_t
H5P__facc_cache_config_dec(const void **_pp, void *_value)
{
    H5AC_cache_config_t *config = (H5AC_cache_config_t *)_value;
    const uint8_t      **pp     = (const uint8_t **)_pp;
    unsigned             enc_size;
    uint64_t             enc_value;
    herr_t               ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    assert(pp);
    assert(*pp);
    assert(config);
    HDcompile_assert(sizeof(size_t) <= sizeof(uint64_t));

    
    H5MM_memcpy(config, &H5F_def_mdc_initCacheCfg_g, sizeof(H5AC_cache_config_t));

    
    enc_size = *(*pp)++;
    if (enc_size != sizeof(unsigned))
        HGOTO_ERROR(H5E_PLIST, H5E_BADVALUE, FAIL, "unsigned value can't be decoded");
    enc_size = *(*pp)++;
    if (enc_size != sizeof(double))
        HGOTO_ERROR(H5E_PLIST, H5E_BADVALUE, FAIL, "double value can't be decoded");

    
    INT32DECODE(*pp, config->version);

    H5_DECODE_UNSIGNED(*pp, config->rpt_fcn_enabled);

    H5_DECODE_UNSIGNED(*pp, config->open_trace_file);

    H5_DECODE_UNSIGNED(*pp, config->close_trace_file);

    strcpy(config->trace_file_name, (const char *)(*pp));
    *pp += H5AC__MAX_TRACE_FILE_NAME_LEN + 1;

    H5_DECODE_UNSIGNED(*pp, config->evictions_enabled);

    H5_DECODE_UNSIGNED(*pp, config->set_initial_size);

    enc_size = *(*pp)++;
    assert(enc_size < 256);
    UINT64DECODE_VAR(*pp, enc_value, enc_size);
    config->initial_size = (size_t)enc_value;

    H5_DECODE_DOUBLE(*pp, config->min_clean_fraction);

    enc_size = *(*pp)++;
    assert(enc_size < 256);
    UINT64DECODE_VAR(*pp, enc_value, enc_size);
    config->max_size = (size_t)enc_value;

    enc_size = *(*pp)++;
    assert(enc_size < 256);
    UINT64DECODE_VAR(*pp, enc_value, enc_size);
    config->min_size = (size_t)enc_value;

    
    {
        int64_t temp;
        INT64DECODE(*pp, temp);
        config->epoch_length = (long int)temp;
    }
    
    config->incr_mode = (enum H5C_cache_incr_mode) * (*pp)++;

    H5_DECODE_DOUBLE(*pp, config->lower_hr_threshold);

    H5_DECODE_DOUBLE(*pp, config->increment);

    H5_DECODE_UNSIGNED(*pp, config->apply_max_increment);

    enc_size = *(*pp)++;
    assert(enc_size < 256);
    UINT64DECODE_VAR(*pp, enc_value, enc_size);
    config->max_increment = (size_t)enc_value;

    
    config->flash_incr_mode = (enum H5C_cache_flash_incr_mode) * (*pp)++;

    H5_DECODE_DOUBLE(*pp, config->flash_multiple);

    H5_DECODE_DOUBLE(*pp, config->flash_threshold);

    
    config->decr_mode = (enum H5C_cache_decr_mode) * (*pp)++;

    H5_DECODE_DOUBLE(*pp, config->upper_hr_threshold);

    H5_DECODE_DOUBLE(*pp, config->decrement);

    H5_DECODE_UNSIGNED(*pp, config->apply_max_decrement);

    enc_size = *(*pp)++;
    assert(enc_size < 256);
    UINT64DECODE_VAR(*pp, enc_value, enc_size);
    config->max_decrement = (size_t)enc_value;

    
    INT32DECODE(*pp, config->epochs_before_eviction);

    H5_DECODE_UNSIGNED(*pp, config->apply_empty_reserve);

    H5_DECODE_DOUBLE(*pp, config->empty_reserve);

    
    UINT32DECODE(*pp, config->dirty_bytes_threshold);

    
    INT32DECODE(*pp, config->metadata_write_strategy);

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_fclose_degree_enc(const void *value, void **_pp, size_t *size)
{
    const H5F_close_degree_t *fclose_degree =
        (const H5F_close_degree_t *)value; 
    uint8_t **pp = (uint8_t **)_pp;

    FUNC_ENTER_PACKAGE_NOERR

    
    assert(fclose_degree);
    assert(size);

    if (NULL != *pp)
        
        *(*pp)++ = (uint8_t)*fclose_degree;

    
    (*size)++;

    FUNC_LEAVE_NOAPI(SUCCEED)
} 

static herr_t
H5P__facc_fclose_degree_dec(const void **_pp, void *_value)
{
    H5F_close_degree_t *fclose_degree = (H5F_close_degree_t *)_value; 
    const uint8_t     **pp            = (const uint8_t **)_pp;

    FUNC_ENTER_PACKAGE_NOERR

    
    assert(pp);
    assert(*pp);
    assert(fclose_degree);

    
    *fclose_degree = (H5F_close_degree_t) * (*pp)++;

    FUNC_LEAVE_NOAPI(SUCCEED)
} 

static herr_t
H5P__facc_multi_type_enc(const void *value, void **_pp, size_t *size)
{
    const H5FD_mem_t *type = (const H5FD_mem_t *)value; 
    uint8_t         **pp   = (uint8_t **)_pp;

    FUNC_ENTER_PACKAGE_NOERR

    
    assert(type);
    assert(size);

    if (NULL != *pp)
        
        *(*pp)++ = (uint8_t)*type;

    
    (*size)++;

    FUNC_LEAVE_NOAPI(SUCCEED)
} 

static herr_t
H5P__facc_multi_type_dec(const void **_pp, void *_value)
{
    H5FD_mem_t     *type = (H5FD_mem_t *)_value; 
    const uint8_t **pp   = (const uint8_t **)_pp;

    FUNC_ENTER_PACKAGE_NOERR

    
    assert(pp);
    assert(*pp);
    assert(type);

    
    *type = (H5FD_mem_t) * (*pp)++;

    FUNC_LEAVE_NOAPI(SUCCEED)
} 

static herr_t
H5P__facc_libver_type_enc(const void *value, void **_pp, size_t *size)
{
    const H5F_libver_t *type = (const H5F_libver_t *)value; 
    uint8_t           **pp   = (uint8_t **)_pp;

    FUNC_ENTER_PACKAGE_NOERR

    
    assert(type);
    assert(size);

    
    if (NULL != *pp)
        *(*pp)++ = (uint8_t)*type;

    
    (*size)++;

    FUNC_LEAVE_NOAPI(SUCCEED)
} 

static herr_t
H5P__facc_libver_type_dec(const void **_pp, void *_value)
{
    H5F_libver_t   *type = (H5F_libver_t *)_value;
    const uint8_t **pp   = (const uint8_t **)_pp;

    FUNC_ENTER_PACKAGE_NOERR

    
    assert(pp);
    assert(*pp);
    assert(type);

    
    *type = (H5F_libver_t) * (*pp)++;

    FUNC_LEAVE_NOAPI(SUCCEED)
} 

herr_t
H5Pset_metadata_read_attempts(hid_t plist_id, unsigned attempts)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (attempts == 0)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL,
                    "number of metadatata read attempts must be greater than 0");

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_set(plist, H5F_ACS_METADATA_READ_ATTEMPTS_NAME, &attempts) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set # of metadata read attempts");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_metadata_read_attempts(hid_t plist_id, unsigned *attempts )
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (attempts) {
        H5P_genplist_t *plist; 

        
        if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, true)))
            HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

        
        if (H5P_get(plist, H5F_ACS_METADATA_READ_ATTEMPTS_NAME, attempts) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get the number of metadata read attempts");

        
        if (*attempts == H5F_ACS_METADATA_READ_ATTEMPTS_DEF) 
            *attempts = H5F_METADATA_READ_ATTEMPTS;
    } 

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pset_object_flush_cb(hid_t plist_id, H5F_flush_cb_t func, void *udata)
{
    H5P_genplist_t    *plist; 
    H5F_object_flush_t flush_info;
    herr_t             ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (!func && udata)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "callback is NULL while user data is not");

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    flush_info.func  = func;
    flush_info.udata = udata;

    
    if (H5P_set(plist, H5F_ACS_OBJECT_FLUSH_CB_NAME, &flush_info) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set object flush callback");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_object_flush_cb(hid_t plist_id, H5F_flush_cb_t *func , void **udata )
{
    H5P_genplist_t    *plist; 
    H5F_object_flush_t flush_info;
    herr_t             ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, true)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_get(plist, H5F_ACS_OBJECT_FLUSH_CB_NAME, &flush_info) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get object flush callback");

    
    if (func)
        *func = flush_info.func;
    if (udata)
        *udata = flush_info.udata;

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pset_mdc_log_options(hid_t plist_id, bool is_enabled, const char *location, bool start_on_access)
{
    H5P_genplist_t *plist;               
    char           *new_location;        
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (H5P_DEFAULT == plist_id)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "can't modify default property list");
    if (!location)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "location cannot be NULL");

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "plist_id is not a file access property list");

    
    if (NULL == (new_location = H5MM_xstrdup(location)))
        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "can't copy passed-in log location");

    
    if (H5P_set(plist, H5F_ACS_USE_MDC_LOGGING_NAME, &is_enabled) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set is_enabled flag");
    if (H5P_set(plist, H5F_ACS_MDC_LOG_LOCATION_NAME, &new_location) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set log location");
    if (H5P_set(plist, H5F_ACS_START_MDC_LOG_ON_ACCESS_NAME, &start_on_access) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set start_on_access flag");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_mdc_log_options(hid_t plist_id, bool *is_enabled , char *location ,
                       size_t *location_size , bool *start_on_access )
{
    H5P_genplist_t *plist;                  
    char           *location_ptr = NULL;    
    herr_t          ret_value    = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, true)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "plist_id is not a file access property list");

    
    if (is_enabled)
        if (H5P_get(plist, H5F_ACS_USE_MDC_LOGGING_NAME, is_enabled) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get log location");
    if (start_on_access)
        if (H5P_get(plist, H5F_ACS_START_MDC_LOG_ON_ACCESS_NAME, start_on_access) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get start_on_access flag");

    
    if (location || location_size)
        if (H5P_get(plist, H5F_ACS_MDC_LOG_LOCATION_NAME, &location_ptr) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get log location");

    
    if (location_ptr && location)
        H5MM_memcpy(location, location_ptr, *location_size);

    
    if (location_size) {
        if (location_ptr)
            *location_size = strlen(location_ptr) + 1;
        else
            *location_size = 0;
    } 

done:
    FUNC_LEAVE_API(ret_value)
} 

static herr_t
H5P__facc_mdc_log_location_enc(const void *value, void **_pp, size_t *size)
{
    const char *log_location = *(const char *const *)value;
    uint8_t   **pp           = (uint8_t **)_pp;
    size_t      len          = 0;
    uint64_t    enc_value;
    unsigned    enc_size;

    FUNC_ENTER_PACKAGE_NOERR

    HDcompile_assert(sizeof(size_t) <= sizeof(uint64_t));

    
    if (NULL != log_location)
        len = strlen(log_location);

    enc_value = (uint64_t)len;
    enc_size  = H5VM_limit_enc_size(enc_value);
    assert(enc_size < 256);

    if (NULL != *pp) {
        
        *(*pp)++ = (uint8_t)enc_size;
        UINT64ENCODE_VAR(*pp, enc_value, enc_size);

        
        if (NULL != log_location) {
            H5MM_memcpy(*(char **)pp, log_location, len);
            *pp += len;
        } 
    }     

    *size += (1 + enc_size);
    if (NULL != log_location)
        *size += len;

    FUNC_LEAVE_NOAPI(SUCCEED)
} 

static herr_t
H5P__facc_mdc_log_location_dec(const void **_pp, void *_value)
{
    char          **log_location = (char **)_value;
    const uint8_t **pp           = (const uint8_t **)_pp;
    size_t          len;
    uint64_t        enc_value; 
    unsigned        enc_size;  
    herr_t          ret_value = SUCCEED;

    FUNC_ENTER_PACKAGE

    assert(pp);
    assert(*pp);
    assert(log_location);
    HDcompile_assert(sizeof(size_t) <= sizeof(uint64_t));

    
    enc_size = *(*pp)++;
    assert(enc_size < 256);

    
    UINT64DECODE_VAR(*pp, enc_value, enc_size);
    len = enc_value;

    if (0 != len) {
        
        if (NULL == (*log_location = (char *)H5MM_malloc(len + 1)))
            HGOTO_ERROR(H5E_RESOURCE, H5E_CANTINIT, FAIL, "memory allocation failed for prefix");
        strncpy(*log_location, *(const char **)pp, len);
        (*log_location)[len] = '\0';

        *pp += len;
    } 
    else
        *log_location = NULL;

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_mdc_log_location_del(hid_t H5_ATTR_UNUSED prop_id, const char H5_ATTR_UNUSED *name,
                               size_t H5_ATTR_UNUSED size, void *value)
{
    FUNC_ENTER_PACKAGE_NOERR

    assert(value);

    H5MM_xfree(*(void **)value);

    FUNC_LEAVE_NOAPI(SUCCEED)
} 

static herr_t
H5P__facc_mdc_log_location_copy(const char H5_ATTR_UNUSED *name, size_t H5_ATTR_UNUSED size, void *value)
{
    FUNC_ENTER_PACKAGE_NOERR

    assert(value);

    *(char **)value = H5MM_xstrdup(*(const char **)value);

    FUNC_LEAVE_NOAPI(SUCCEED)
} 

static H5_ATTR_PURE int
H5P__facc_mdc_log_location_cmp(const void *value1, const void *value2, size_t H5_ATTR_UNUSED size)
{
    const char *pref1     = *(const char *const *)value1;
    const char *pref2     = *(const char *const *)value2;
    int         ret_value = 0;

    FUNC_ENTER_PACKAGE_NOERR

    if (NULL == pref1 && NULL != pref2)
        HGOTO_DONE(1);
    if (NULL != pref1 && NULL == pref2)
        HGOTO_DONE(-1);
    if (NULL != pref1 && NULL != pref2)
        ret_value = strcmp(pref1, pref2);

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_mdc_log_location_close(const char H5_ATTR_UNUSED *name, size_t H5_ATTR_UNUSED size, void *value)
{
    FUNC_ENTER_PACKAGE_NOERR

    assert(value);

    H5MM_xfree(*(void **)value);

    FUNC_LEAVE_NOAPI(SUCCEED)
} 

herr_t
H5Pset_evict_on_close(hid_t fapl_id, bool evict_on_close)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (true != H5P_isa_class(fapl_id, H5P_FILE_ACCESS))
        HGOTO_ERROR(H5E_PLIST, H5E_CANTREGISTER, FAIL, "property list is not a file access plist");

    
    if (NULL == (plist = (H5P_genplist_t *)H5I_object(fapl_id)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_set(plist, H5F_ACS_EVICT_ON_CLOSE_FLAG_NAME, &evict_on_close) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set evict on close property");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_evict_on_close(hid_t fapl_id, bool *evict_on_close )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (true != H5P_isa_class(fapl_id, H5P_FILE_ACCESS))
        HGOTO_ERROR(H5E_PLIST, H5E_CANTREGISTER, FAIL, "property list is not an access plist");

    
    if (NULL == (plist = (H5P_genplist_t *)H5I_object(fapl_id)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    if (H5P_get(plist, H5F_ACS_EVICT_ON_CLOSE_FLAG_NAME, evict_on_close) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get evict on close property");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pset_file_locking(hid_t fapl_id, bool use_file_locking, bool ignore_when_disabled)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (true != H5P_isa_class(fapl_id, H5P_FILE_ACCESS))
        HGOTO_ERROR(H5E_PLIST, H5E_CANTREGISTER, FAIL, "property list is not a file access plist");

    
    if (NULL == (plist = (H5P_genplist_t *)H5I_object(fapl_id)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_set(plist, H5F_ACS_USE_FILE_LOCKING_NAME, &use_file_locking) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set use file locking property");
    if (H5P_set(plist, H5F_ACS_IGNORE_DISABLED_FILE_LOCKS_NAME, &ignore_when_disabled) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set ignore disabled file locks property");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_file_locking(hid_t fapl_id, bool *use_file_locking , bool *ignore_when_disabled )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (H5P_DEFAULT == fapl_id)
        fapl_id = H5P_FILE_ACCESS_DEFAULT;
    else if (true != H5P_isa_class(fapl_id, H5P_FILE_ACCESS))
        HGOTO_ERROR(H5E_PLIST, H5E_CANTREGISTER, FAIL, "property list is not an access plist");

    
    if (NULL == (plist = (H5P_genplist_t *)H5I_object(fapl_id)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_get(plist, H5F_ACS_USE_FILE_LOCKING_NAME, use_file_locking) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get use file locking property");
    if (H5P_get(plist, H5F_ACS_IGNORE_DISABLED_FILE_LOCKS_NAME, ignore_when_disabled) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get ignore disabled file locks property");

done:
    FUNC_LEAVE_API(ret_value)
} 

#ifdef H5_HAVE_PARALLEL

herr_t
H5P__encode_coll_md_read_flag_t(const void *value, void **_pp, size_t *size)
{
    const H5P_coll_md_read_flag_t *coll_md_read_flag = (const H5P_coll_md_read_flag_t *)value;
    uint8_t                      **pp                = (uint8_t **)_pp;

    FUNC_ENTER_PACKAGE_NOERR

    
    assert(coll_md_read_flag);
    assert(size);

    if (NULL != *pp) {
        
        H5MM_memcpy(*pp, coll_md_read_flag, sizeof(H5P_coll_md_read_flag_t));
        *pp += sizeof(H5P_coll_md_read_flag_t);
    } 

    
    *size += sizeof(H5P_coll_md_read_flag_t);

    FUNC_LEAVE_NOAPI(SUCCEED)
} 

herr_t
H5P__decode_coll_md_read_flag_t(const void **_pp, void *_value)
{
    H5P_coll_md_read_flag_t *coll_md_read_flag = (H5P_coll_md_read_flag_t *)_value; 
    const uint8_t          **pp                = (const uint8_t **)_pp;

    FUNC_ENTER_PACKAGE_NOERR

    
    assert(pp);
    assert(*pp);
    assert(coll_md_read_flag);

    
    *coll_md_read_flag = (H5P_coll_md_read_flag_t) * (*pp);
    *pp += sizeof(H5P_coll_md_read_flag_t);

    FUNC_LEAVE_NOAPI(SUCCEED)
} 

herr_t
H5Pset_all_coll_metadata_ops(hid_t plist_id, bool is_collective)
{
    H5P_genplist_t         *plist;               
    H5P_coll_md_read_flag_t coll_meta_read;      
    herr_t                  ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    
    if (true != H5P_isa_class(plist_id, H5P_LINK_ACCESS) && true != H5P_isa_class(plist_id, H5P_FILE_ACCESS))
        HGOTO_ERROR(H5E_PLIST, H5E_CANTREGISTER, FAIL, "property list is not an access plist");

    
    if (is_collective)
        coll_meta_read = H5P_USER_TRUE;
    else
        coll_meta_read = H5P_USER_FALSE;

    
    if (NULL == (plist = (H5P_genplist_t *)H5I_object(plist_id)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_set(plist, H5_COLL_MD_READ_FLAG_NAME, &coll_meta_read) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set collective metadata read flag");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_all_coll_metadata_ops(hid_t plist_id, bool *is_collective )
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    
    if (true != H5P_isa_class(plist_id, H5P_LINK_ACCESS) && true != H5P_isa_class(plist_id, H5P_FILE_ACCESS))
        HGOTO_ERROR(H5E_PLIST, H5E_CANTREGISTER, FAIL, "property list is not an access plist");

    
    if (is_collective) {
        H5P_coll_md_read_flag_t
                        internal_flag; 
        H5P_genplist_t *plist;         

        
        if (NULL == (plist = (H5P_genplist_t *)H5I_object(plist_id)))
            HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

        if (H5P_get(plist, H5_COLL_MD_READ_FLAG_NAME, &internal_flag) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get core collective metadata read flag");

        if (internal_flag < 0)
            *is_collective = false;
        else
            *is_collective = (bool)internal_flag;
    } 

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pset_coll_metadata_write(hid_t plist_id, bool is_collective)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (true != H5P_isa_class(plist_id, H5P_FILE_ACCESS))
        HGOTO_ERROR(H5E_PLIST, H5E_CANTREGISTER, FAIL, "property list is not a file access plist");

    
    if (NULL == (plist = (H5P_genplist_t *)H5I_object(plist_id)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_set(plist, H5F_ACS_COLL_MD_WRITE_FLAG_NAME, &is_collective) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set collective metadata write flag");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_mpi_params(hid_t plist_id, MPI_Comm *comm , MPI_Info *info )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (true != H5P_isa_class(plist_id, H5P_FILE_ACCESS))
        HGOTO_ERROR(H5E_PLIST, H5E_CANTREGISTER, FAIL, "property list is not a file access plist");

    
    if (NULL == (plist = (H5P_genplist_t *)H5I_object(plist_id)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_get(plist, H5F_ACS_MPI_PARAMS_COMM_NAME, comm) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get MPI communicator from plist");
    if (H5P_get(plist, H5F_ACS_MPI_PARAMS_INFO_NAME, info) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get MPI info from plist");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pset_mpi_params(hid_t plist_id, MPI_Comm comm, MPI_Info info)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (MPI_COMM_NULL == comm)
        HGOTO_ERROR(H5E_PLIST, H5E_BADVALUE, FAIL, "not a valid argument");

    
    if (true != H5P_isa_class(plist_id, H5P_FILE_ACCESS))
        HGOTO_ERROR(H5E_PLIST, H5E_CANTREGISTER, FAIL, "property list is not a file access plist");

    
    if (NULL == (plist = (H5P_genplist_t *)H5I_object(plist_id)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    
    if (H5P_set(plist, H5F_ACS_MPI_PARAMS_COMM_NAME, &comm) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set MPI communicator");
    if (H5P_set(plist, H5F_ACS_MPI_PARAMS_INFO_NAME, &info) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set MPI info object");

done:
    FUNC_LEAVE_API(ret_value)
} 

static herr_t
H5P__facc_mpi_comm_set(hid_t H5_ATTR_UNUSED prop_id, const char H5_ATTR_UNUSED *name,
                       size_t H5_ATTR_UNUSED size, void *value)
{
    MPI_Comm *comm      = (MPI_Comm *)value;
    MPI_Comm  comm_tmp  = MPI_COMM_NULL;
    herr_t    ret_value = SUCCEED;

    FUNC_ENTER_PACKAGE

    
    if (H5_mpi_comm_dup(*comm, &comm_tmp) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "unable to duplicate MPI communicator");

done:
    
    if (ret_value != SUCCEED)
        *comm = MPI_COMM_NULL;
    else
        *comm = comm_tmp;

    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_mpi_comm_get(hid_t H5_ATTR_UNUSED prop_id, const char H5_ATTR_UNUSED *name,
                       size_t H5_ATTR_UNUSED size, void *value)
{
    MPI_Comm *comm      = (MPI_Comm *)value;
    MPI_Comm  comm_tmp  = MPI_COMM_NULL;
    herr_t    ret_value = SUCCEED;

    FUNC_ENTER_PACKAGE

    
    if (H5_mpi_comm_dup(*comm, &comm_tmp) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "unable to duplicate MPI communicator");

done:
    
    if (ret_value != SUCCEED)
        *comm = MPI_COMM_NULL;
    else
        *comm = comm_tmp;

    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_mpi_comm_del(hid_t H5_ATTR_UNUSED prop_id, const char H5_ATTR_UNUSED *name,
                       size_t H5_ATTR_UNUSED size, void *value)
{
    MPI_Comm *comm      = (MPI_Comm *)value;
    herr_t    ret_value = SUCCEED;

    FUNC_ENTER_PACKAGE

    
    if (H5_mpi_comm_free(comm) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTFREE, FAIL, "unable to free MPI communicator");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_mpi_comm_copy(const char H5_ATTR_UNUSED *name, size_t H5_ATTR_UNUSED size, void *value)
{
    MPI_Comm *comm      = (MPI_Comm *)value;
    MPI_Comm  comm_tmp  = MPI_COMM_NULL;
    herr_t    ret_value = SUCCEED;

    FUNC_ENTER_PACKAGE

    
    if (H5_mpi_comm_dup(*comm, &comm_tmp) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "unable to duplicate MPI communicator");

done:
    
    if (ret_value != SUCCEED)
        *comm = MPI_COMM_NULL;
    else
        *comm = comm_tmp;

    FUNC_LEAVE_NOAPI(ret_value)
} 

static int
H5P__facc_mpi_comm_cmp(const void *_comm1, const void *_comm2, size_t H5_ATTR_UNUSED size)
{
    const MPI_Comm *comm1     = (const MPI_Comm *)_comm1;
    const MPI_Comm *comm2     = (const MPI_Comm *)_comm2;
    int             ret_value = 0;

    FUNC_ENTER_PACKAGE

    
    if (H5_mpi_comm_cmp(*comm1, *comm2, &ret_value) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, 0, "unable to compare MPI communicator");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_mpi_comm_close(const char H5_ATTR_UNUSED *name, size_t H5_ATTR_UNUSED size, void *value)
{
    MPI_Comm *comm      = (MPI_Comm *)value;
    herr_t    ret_value = SUCCEED;

    FUNC_ENTER_PACKAGE

    
    if (H5_mpi_comm_free(comm) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTFREE, FAIL, "unable to free MPI communicator");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_mpi_info_set(hid_t H5_ATTR_UNUSED prop_id, const char H5_ATTR_UNUSED *name,
                       size_t H5_ATTR_UNUSED size, void *value)
{
    MPI_Info *info      = (MPI_Info *)value;
    MPI_Info  info_tmp  = MPI_INFO_NULL;
    herr_t    ret_value = SUCCEED;

    FUNC_ENTER_PACKAGE

    
    if (H5_mpi_info_dup(*info, &info_tmp) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "unable to duplicate MPI info object");

done:
    
    if (ret_value != SUCCEED)
        *info = MPI_INFO_NULL;
    else
        *info = info_tmp;

    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_mpi_info_get(hid_t H5_ATTR_UNUSED prop_id, const char H5_ATTR_UNUSED *name,
                       size_t H5_ATTR_UNUSED size, void *value)
{
    MPI_Info *info      = (MPI_Info *)value;
    MPI_Info  info_tmp  = MPI_INFO_NULL;
    herr_t    ret_value = SUCCEED;

    FUNC_ENTER_PACKAGE

    
    if (H5_mpi_info_dup(*info, &info_tmp) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "unable to duplicate MPI info object");

done:
    
    if (ret_value != SUCCEED)
        *info = MPI_INFO_NULL;
    else
        *info = info_tmp;

    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_mpi_info_del(hid_t H5_ATTR_UNUSED prop_id, const char H5_ATTR_UNUSED *name,
                       size_t H5_ATTR_UNUSED size, void *value)
{
    MPI_Info *info      = (MPI_Info *)value;
    herr_t    ret_value = SUCCEED;

    FUNC_ENTER_PACKAGE

    
    if (H5_mpi_info_free(info) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTFREE, FAIL, "unable to free MPI info object");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_mpi_info_copy(const char H5_ATTR_UNUSED *name, size_t H5_ATTR_UNUSED size, void *value)
{
    MPI_Info *info      = (MPI_Info *)value;
    MPI_Info  info_tmp  = MPI_INFO_NULL;
    herr_t    ret_value = SUCCEED;

    FUNC_ENTER_PACKAGE

    
    if (H5_mpi_info_dup(*info, &info_tmp) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "unable to duplicate MPI info object");

done:
    
    if (ret_value != SUCCEED)
        *info = MPI_INFO_NULL;
    else
        *info = info_tmp;

    FUNC_LEAVE_NOAPI(ret_value)
} 

static int
H5P__facc_mpi_info_cmp(const void *_info1, const void *_info2, size_t H5_ATTR_UNUSED size)
{
    const MPI_Info *info1     = (const MPI_Info *)_info1;
    const MPI_Info *info2     = (const MPI_Info *)_info2;
    int             ret_value = 0;

    FUNC_ENTER_PACKAGE

    
    if (H5_mpi_info_cmp(*info1, *info2, &ret_value) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, 0, "unable to compare MPI info objects");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_mpi_info_close(const char H5_ATTR_UNUSED *name, size_t H5_ATTR_UNUSED size, void *value)
{
    MPI_Info *info      = (MPI_Info *)value;
    herr_t    ret_value = SUCCEED;

    FUNC_ENTER_PACKAGE

    
    if (H5_mpi_info_free(info) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTFREE, FAIL, "unable to free MPI info object");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5Pget_coll_metadata_write(hid_t plist_id, bool *is_collective )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (true != H5P_isa_class(plist_id, H5P_FILE_ACCESS))
        HGOTO_ERROR(H5E_PLIST, H5E_CANTREGISTER, FAIL, "property list is not an access plist");

    
    if (NULL == (plist = (H5P_genplist_t *)H5I_object(plist_id)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    if (H5P_get(plist, H5F_ACS_COLL_MD_WRITE_FLAG_NAME, is_collective) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get collective metadata write flag");

done:
    FUNC_LEAVE_API(ret_value)
} 
#endif 

herr_t
H5Pset_page_buffer_size(hid_t plist_id, size_t buf_size, unsigned min_meta_perc, unsigned min_raw_perc)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    if (min_meta_perc > 100)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL,
                    "Minimum metadata fractions must be between 0 and 100 inclusive");
    if (min_raw_perc > 100)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL,
                    "Minimum raw data fractions must be between 0 and 100 inclusive");

    if (min_meta_perc + min_raw_perc > 100)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL,
                    "Sum of minimum metadata and raw data fractions can't be bigger than 100");

    
    if (H5P_set(plist, H5F_ACS_PAGE_BUFFER_SIZE_NAME, &buf_size) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set page buffer size");
    if (H5P_set(plist, H5F_ACS_PAGE_BUFFER_MIN_META_PERC_NAME, &min_meta_perc) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set percentage of min metadata entries");
    if (H5P_set(plist, H5F_ACS_PAGE_BUFFER_MIN_RAW_PERC_NAME, &min_raw_perc) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set percentage of min raw data entries");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_page_buffer_size(hid_t plist_id, size_t *buf_size , unsigned *min_meta_perc ,
                        unsigned *min_raw_perc )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, true)))
        HGOTO_ERROR(H5E_ID, H5E_BADID, FAIL, "can't find object for ID");

    

    if (buf_size) {
        if (H5P_get(plist, H5F_ACS_PAGE_BUFFER_SIZE_NAME, buf_size) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get page buffer size");
        if (*buf_size == H5F_PAGE_BUFFER_SIZE_DEFAULT)
            *buf_size = H5PB_SIZE_DEFAULT_VALUE;
    }
    if (min_meta_perc)
        if (H5P_get(plist, H5F_ACS_PAGE_BUFFER_MIN_META_PERC_NAME, min_meta_perc) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get page buffer minimum metadata percent");
    if (min_raw_perc)
        if (H5P_get(plist, H5F_ACS_PAGE_BUFFER_MIN_RAW_PERC_NAME, min_raw_perc) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get page buffer minimum raw data percent");

done:
    FUNC_LEAVE_API(ret_value)
} 

static herr_t
H5P__facc_page_buffer_size_enc(const void *value, void **_pp, size_t *size)
{
    uint64_t     enc_value = 0; 
    uint8_t    **pp        = (uint8_t **)_pp;
    unsigned     enc_size;            
    H5F_libver_t low_bound;           
    H5F_libver_t high_bound;          
    herr_t       ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    HDcompile_assert(sizeof(size_t) <= sizeof(uint64_t));
    assert(size);

    
    if (H5CX_get_libver_bounds(&low_bound, &high_bound) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get low/high bounds from API context");

    
    if (low_bound < H5F_LIBVER_V200) {
        
        if (*(const size_t *)value == H5F_PAGE_BUFFER_SIZE_DEFAULT)
            enc_value = (uint64_t)H5PB_SIZE_DEFAULT_VALUE;
        else
            enc_value = (uint64_t) * (const size_t *)value;

        
        enc_size = H5VM_limit_enc_size(enc_value);
        assert(enc_size > 0);
        *size += (1 + enc_size);
    }
    else {
        
        if (*(const size_t *)value == H5PB_SIZE_DEFAULT_VALUE) {
            enc_size = 0;
            *size += 1;
        }
        else {
            
            enc_value = (uint64_t) * (const size_t *)value;
            enc_size  = H5VM_limit_enc_size(enc_value);
            assert(enc_size > 0);
            *size += (1 + enc_size);
        }
    }

    assert(enc_size < 256);

    if (NULL != *pp) {
        
        *(*pp)++ = (uint8_t)enc_size;

        
        if (enc_size != 0) {
            UINT64ENCODE_VAR(*pp, enc_value, enc_size);
        } 
    }     

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_page_buffer_size_dec(const void **_pp, void *_value)
{
    size_t         *value = (size_t *)_value; 
    const uint8_t **pp    = (const uint8_t **)_pp;
    uint64_t        enc_value; 
    unsigned        enc_size;  

    FUNC_ENTER_PACKAGE_NOERR

    
    HDcompile_assert(sizeof(size_t) <= sizeof(uint64_t));
    assert(pp);
    assert(*pp);
    assert(value);

    
    enc_size = *(*pp)++;
    assert(enc_size < 256);

    
    if (enc_size == 0)
        *value = H5PB_SIZE_DEFAULT_VALUE;
    else {
        
        UINT64DECODE_VAR(*pp, enc_value, enc_size);

        
        if (enc_value == H5PB_SIZE_DEFAULT_VALUE)
            *value = H5F_PAGE_BUFFER_SIZE_DEFAULT;
        else
            H5_CHECKED_ASSIGN(*value, uint64_t, enc_value, size_t);
    } 

    FUNC_LEAVE_NOAPI(SUCCEED)
} 

herr_t
H5P_set_vol(H5P_genplist_t *plist, H5VL_connector_t *connector, const void *vol_info)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_NOAPI(FAIL)

    
    assert(connector);

    if (true == H5P_isa_class(plist->plist_id, H5P_FILE_ACCESS)) {
        H5VL_connector_prop_t vol_prop; 

        
        vol_prop.connector      = connector;
        vol_prop.connector_info = vol_info;

        
        if (H5P_set(plist, H5F_ACS_VOL_CONN_NAME, &vol_prop) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set VOL connector ID & info");
    } 
    else
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a file access property list");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5P_reset_vol_class(const H5P_genclass_t *pclass, const H5VL_connector_prop_t *vol_prop)
{
    H5VL_connector_prop_t old_vol_prop;        
    herr_t                ret_value = SUCCEED; 

    FUNC_ENTER_NOAPI(FAIL)

    
    if (H5P__class_get(pclass, H5F_ACS_VOL_CONN_NAME, &old_vol_prop) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get VOL connector ID & info");

    
    if (H5P__class_set(pclass, H5F_ACS_VOL_CONN_NAME, vol_prop) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set VOL connector ID & info");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5Pset_vol(hid_t plist_id, hid_t new_vol_id, const void *new_vol_info)
{
    H5P_genplist_t   *plist;               
    H5VL_connector_t *connector;           
    herr_t            ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = (H5P_genplist_t *)H5P_object_verify(plist_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a property list");
    if (NULL == (connector = H5I_object_verify(new_vol_id, H5I_VOL)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a file VOL ID");

    
    if (H5P_set_vol(plist, connector, new_vol_info) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set VOL");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_vol_id(hid_t plist_id, hid_t *vol_id )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    if (H5P_DEFAULT == plist_id)
        plist_id = H5P_FILE_ACCESS_DEFAULT;

    
    if (NULL == (plist = (H5P_genplist_t *)H5I_object_verify(plist_id, H5I_GENPROP_LST)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a property list");

    
    if (true == H5P_isa_class(plist->plist_id, H5P_FILE_ACCESS)) {
        H5VL_connector_prop_t connector_prop; 

        
        if (H5P_peek(plist, H5F_ACS_VOL_CONN_NAME, &connector_prop) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get VOL connector info");

        
        if ((*vol_id = H5VL_conn_register(connector_prop.connector)) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTINC, FAIL, "unable to increment ref count on VOL connector");
    } 
    else
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a file access property list");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_vol_info(hid_t plist_id, void **vol_info )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (NULL == (plist = (H5P_genplist_t *)H5I_object_verify(plist_id, H5I_GENPROP_LST)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a property list");

    
    if (true == H5P_isa_class(plist->plist_id, H5P_FILE_ACCESS)) {
        void                 *new_connector_info = NULL; 
        H5VL_connector_prop_t connector_prop;            

        
        if (H5P_peek(plist, H5F_ACS_VOL_CONN_NAME, &connector_prop) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get VOL connector property");

        
        if (connector_prop.connector_info)
            
            if (H5VL_copy_connector_info(connector_prop.connector, &new_connector_info,
                                         connector_prop.connector_info) < 0)
                HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "connector info copy failed");

        
        *vol_info = new_connector_info;
    } 
    else
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a file access property list");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_vol_cap_flags(hid_t plist_id, uint64_t *cap_flags)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (cap_flags) {
        if (H5P_DEFAULT == plist_id)
            plist_id = H5P_FILE_ACCESS_DEFAULT;

        if (true == H5P_isa_class(plist_id, H5P_FILE_ACCESS)) {
            H5P_genplist_t       *plist;          
            H5VL_connector_prop_t connector_prop; 

            
            if (NULL == (plist = (H5P_genplist_t *)H5I_object_verify(plist_id, H5I_GENPROP_LST)))
                HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a property list");

            
            if (H5P_peek(plist, H5F_ACS_VOL_CONN_NAME, &connector_prop) < 0)
                HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get VOL connector property");

            
            if (H5VL_conn_prop_get_cap_flags(&connector_prop, cap_flags) < 0)
                HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get VOL connector capability flags");
        }
        else
            HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a file access property list");
    }

done:
    FUNC_LEAVE_API(ret_value)
} 

static herr_t
H5P__facc_vol_create(const char H5_ATTR_UNUSED *name, size_t H5_ATTR_UNUSED size, void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (H5VL_conn_prop_copy((H5VL_connector_prop_t *)value) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "can't copy VOL connector");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_vol_set(hid_t H5_ATTR_UNUSED prop_id, const char H5_ATTR_UNUSED *name, size_t H5_ATTR_UNUSED size,
                  void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    assert(value);

    
    if (H5VL_conn_prop_copy((H5VL_connector_prop_t *)value) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "can't copy VOL connector");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_vol_get(hid_t H5_ATTR_UNUSED prop_id, const char H5_ATTR_UNUSED *name, size_t H5_ATTR_UNUSED size,
                  void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    assert(value);

    
    if (H5VL_conn_prop_copy((H5VL_connector_prop_t *)value) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "can't copy VOL connector");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_vol_del(hid_t H5_ATTR_UNUSED prop_id, const char H5_ATTR_UNUSED *name, size_t H5_ATTR_UNUSED size,
                  void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (H5VL_conn_prop_free((H5VL_connector_prop_t *)value) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTRELEASE, FAIL, "can't release VOL connector");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_vol_copy(const char H5_ATTR_UNUSED *name, size_t H5_ATTR_UNUSED size, void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (H5VL_conn_prop_copy((H5VL_connector_prop_t *)value) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTCOPY, FAIL, "can't copy VOL connector");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

static int
H5P__facc_vol_cmp(const void *_prop1, const void *_prop2, size_t H5_ATTR_UNUSED size)
{
    const H5VL_connector_prop_t *prop1 =
        (const H5VL_connector_prop_t *)_prop1; 
    const H5VL_connector_prop_t *prop2 = (const H5VL_connector_prop_t *)_prop2;
    herr_t H5_ATTR_NDEBUG_UNUSED status;        
    int                          ret_value = 0; 

    FUNC_ENTER_PACKAGE_NOERR

    
    assert(prop1);
    assert(prop2);
    assert(size == sizeof(H5VL_connector_prop_t));

    
    status = H5VL_conn_prop_cmp(&ret_value, prop1, prop2);
    assert(status >= 0);

    FUNC_LEAVE_NOAPI(ret_value)
} 

static herr_t
H5P__facc_vol_close(const char H5_ATTR_UNUSED *name, size_t H5_ATTR_UNUSED size, void *value)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (H5VL_conn_prop_free((H5VL_connector_prop_t *)value) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTRELEASE, FAIL, "can't release VOL connector");

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5Pset_relax_file_integrity_checks(hid_t plist_id, uint64_t flags)
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    
    if (H5P_DEFAULT == plist_id)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "can't modify default property list");
    if (flags & (uint64_t)~H5F_RFIC_ALL)
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "invalid flags");

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, false)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "plist_id is not a file access property list");

    
    if (H5P_set(plist, H5F_ACS_RFIC_FLAGS_NAME, &flags) < 0)
        HGOTO_ERROR(H5E_PLIST, H5E_CANTSET, FAIL, "can't set relaxed file integrity check flags");

done:
    FUNC_LEAVE_API(ret_value)
} 

herr_t
H5Pget_relax_file_integrity_checks(hid_t plist_id, uint64_t *flags )
{
    H5P_genplist_t *plist;               
    herr_t          ret_value = SUCCEED; 

    FUNC_ENTER_API(FAIL)

    if (H5P_DEFAULT == plist_id)
        plist_id = H5P_FILE_ACCESS_DEFAULT;

    
    if (NULL == (plist = H5P_object_verify(plist_id, H5P_FILE_ACCESS, true)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADVALUE, FAIL, "plist_id is not a file access property list");

    
    if (flags)
        if (H5P_get(plist, H5F_ACS_RFIC_FLAGS_NAME, flags) < 0)
            HGOTO_ERROR(H5E_PLIST, H5E_CANTGET, FAIL, "can't get relaxed file integrity check flags");

done:
    FUNC_LEAVE_API(ret_value)
} 
