/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef H5VLpassthru_H
#define H5VLpassthru_H

#include "H5VLpublic.h" 

#define H5VL_PASSTHRU (H5OPEN H5VL_PASSTHRU_g)

#define H5VL_PASSTHRU_NAME    "pass_through"
#define H5VL_PASSTHRU_VALUE   1 
#define H5VL_PASSTHRU_VERSION 0

typedef struct H5VL_pass_through_info_t {
    hid_t under_vol_id;   
    void *under_vol_info; 
} H5VL_pass_through_info_t;

#ifdef __cplusplus
extern "C" {
#endif

H5_DLLVAR hid_t H5VL_PASSTHRU_g;

#ifdef __cplusplus
}
#endif

#endif 
