% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotcde.R
\name{hdr.cde}
\alias{hdr.cde}
\title{Calculate highest density regions continuously over some conditioned
variable.}
\usage{
hdr.cde(den, prob = c(0.5, 0.95, 0.99), plot = TRUE, nn = 1000, ...)
}
\arguments{
\item{den}{Conditional density in the same format as the output from
\code{\link[=cde]{cde()}}.}

\item{prob}{Probability coverage level for HDRs}

\item{plot}{Should HDRs be plotted? If FALSE, results are returned.}

\item{nn}{Number of points to be sampled from each density when estimating the HDRs.}

\item{\dots}{Other arguments passed to \code{\link[=plot.hdrcde]{plot.hdrcde()}}.}
}
\value{
\item{hdr}{array (a,b,c) where where a specifies conditioning value,
b gives the HDR endpoints and c gives the probability coverage.}
\item{modes}{estimated mode of each conditional density}
The result is returned invisibly if \code{plot=TRUE}.
}
\description{
Calculates and plots highest density regions for a conditional density
estimate. Uses output from \code{\link[=cde]{cde()}}.
}
\examples{
faithful.cde <- cde(faithful$waiting, faithful$eruptions)
faithful.hdr <- hdr.cde(faithful.cde, prob = c(0.50, 0.95))
faithful.hdr
plot(faithful.hdr, xlab = "Waiting time", ylab = "Duration time")
}
\references{
Hyndman, R.J., Bashtannyk, D.M. and Grunwald, G.K. (1996)
"Estimating and visualizing conditional densities". \emph{Journal of
Computational and Graphical Statistics}, \strong{5}, 315-336.
}
\seealso{
\code{\link[=plot.hdrcde]{plot.hdrcde()}}, \code{\link[=cde]{cde()}},
}
\author{
Rob J Hyndman
}
\keyword{distribution}
\keyword{hplot}
\keyword{smooth}
