% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zigzagMarkovian.R
\name{getMarkovianZigzagSample}
\alias{getMarkovianZigzagSample}
\title{Draw one Markovian zigzag sample}
\usage{
getMarkovianZigzagSample(position, velocity = NULL, engine, travelTime)
}
\arguments{
\item{position}{a d-dimensional position vector.}

\item{velocity}{optional d-dimensional velocity vector. If NULL, it will be generated within the function.}

\item{engine}{an object representing the Markovian zigzag engine, typically containing settings and state required for the simulation.}

\item{travelTime}{the duration for which the dynamics are simulated.}
}
\value{
A list containing the position and velocity after simulating the dynamics.
}
\description{
Simulate the Markovian zigzag dynamics for a given position over a specified travel time.
}
\examples{
# First create an engine
set.seed(123)
engine <- createEngine(
  dimension = 2,
  lowerBounds = c(-1, -1),
  upperBounds = c(1, 1),
  seed = 123,
  mean = c(0, 0),
  precision = diag(2)
)

# Draw a single Markovian zigzag sample
position <- c(0.1, -0.2)
travel_time <- 0.5
sample_result <- getMarkovianZigzagSample(
  position = position,
  engine = engine,
  travelTime = travel_time
)
sample_result
}
\seealso{
\code{\link[=markovianZigzag]{markovianZigzag()}}
}
