% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_lifetable.R
\name{prepare_lifetable}
\alias{prepare_lifetable}
\title{Convert multi-year life table to single year life table}
\usage{
prepare_lifetable(age_group, population, bhd)
}
\arguments{
\item{age_group}{\code{Numeric vector} referring to the first years of the age groups. E.g. c(0, 20, 40, 60) means [0, 20), [20, 40), [40, 60), [60, )}

\item{population}{\code{Numeric vector} referring to mid-year populations by age group.}

\item{bhd}{\code{Numeric vector} referring to the baseline health data (deaths) by age group.}
}
\value{
This function returns a \code{tibble} containing the columns:
\itemize{
 \item \code{population_for_attribute} (\code{numeric}) containing  population values for each age
 \item \code{bhd_for_attribute} (\code{numeric}) containing baseline health data values for each age
 \item and more columns containing input data or results
}
}
\description{
This function determines populations and deaths by one year age groups.
}
\details{
\strong{Methodology}

The conversion follows the methodology of the WHO tool.
See the AirQ+ manual
"Health impact assessment of air pollution: AirQ+ life table manual"
for guidance on how to convert larger age groups to 1 year age groups,
section "Estimation of yearly values" \insertCite{WHO2020_report}{healthiar}.

Detailed information about the methodology (including equations)
is available in the package vignette.
More specifically, see chapters:
\itemize{
 \item \href{https://swisstph.github.io/healthiar/articles/intro_to_healthiar.html#yll-deaths-with-life-table}{YLL and deaths with life table}}
}
\examples{
# Goal: Convert 5-year population and death data into single year life table
results <- prepare_lifetable(
  age_group = c(0, 5, 10, 15),
  population = c(3387900, 3401300, 3212300, 3026100),
  bhd = c(4727, 472, 557, 1323)
)


}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
  \item Downstream: \code{\link{attribute_lifetable}}
}
}
\author{
Alberto Castro & Axel Luyten
}
