% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.robmlm.R
\name{plot.robmlm}
\alias{plot.robmlm}
\title{Plot observation weights from a robust multivariate linear models}
\usage{
\method{plot}{robmlm}(
  x,
  labels,
  groups,
  group.axis = TRUE,
  id.weight = 0.7,
  id.pos = 4,
  pch = 19,
  col = palette()[1],
  cex = par("cex"),
  segments = FALSE,
  xlab = "Case index",
  ylab = "Weight in robust MLM",
  ...
)
}
\arguments{
\item{x}{A \code{"robmlm"} object}

\item{labels}{Observation labels for point identification. If not specified, uses \code{rownames} from the
original data}

\item{groups}{Optional grouping variable, a factor with length equal to the number of observations, used to  identify groups in the plot.}

\item{group.axis}{Logical; whether to draw an axis at the top identifying the groups. Not drawn if \code{groups} is missing.}

\item{id.weight}{Threshold for identifying observations with small weights}

\item{id.pos}{Position of observation label relative to the point}

\item{pch}{Point symbol(s); can be a vector of length equal to the number of
observations in the data frame.}

\item{col}{Point color(s).  Multiple colors can be specified so that each point can be given its own color. If there are fewer colors than points they are recycled in the standard fashion.}

\item{cex}{Point character size(s)}

\item{segments}{logical; if \code{TRUE}, draw line segments from 1.0 down to
the point}

\item{xlab}{x axis label}

\item{ylab}{y axis label}

\item{\dots}{other arguments passed to \code{\link[graphics]{plot}}}
}
\value{
Returns invisibly the weights for the observations labeled in the
plot
}
\description{
Creates an index plot of the observation weights assigned in the last
iteration of \code{\link{robmlm}}.  Observations with low weights have large
residual squared distances and are potential multivariate outliers with
respect to the fitted model.
}
\examples{

data(Skulls)
sk.rmod <- robmlm(cbind(mb, bh, bl, nh) ~ epoch, data=Skulls)
plot(sk.rmod, col=Skulls$epoch, segments=TRUE)
axis(side=3, at=15+seq(0,120,30), labels=levels(Skulls$epoch), cex.axis=1)

# Pottery data

data(Pottery, package = "carData")
pottery.rmod <- robmlm(cbind(Al,Fe,Mg,Ca,Na)~Site, data=Pottery)
plot(pottery.rmod, col=Pottery$Site, segments=TRUE)

# SocialCog data

data(SocialCog)
SC.rmod <- robmlm(cbind( MgeEmotions, ToM, ExtBias, PersBias) ~ Dx,
               data=SocialCog)
plot(SC.rmod, 
     col=SocialCog$Dx, segments=TRUE)
# label the groups 
ctr <- split(seq(nrow(SocialCog)), SocialCog$Dx) |> lapply(mean)
axis(side = 3, at=ctr, labels = names(ctr), cex.axis=1.2)

# use the groups arg
colors = c("red", "darkgreen", "blue") 
ids <- plot(SC.rmod, 
     groups=SocialCog$Dx, 
     col = colors,
     pch = 15:17,
     segments=TRUE)

# the cases labeled and their weights
ids


}
\seealso{
\code{\link{robmlm}}

Other robust methods: 
\code{\link{Mahalanobis}()},
\code{\link{robmlm}()}
}
\author{
Michael Friendly
}
\concept{robust methods}
\keyword{hplot}
