% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametise.R
\name{H2_Cullis_parameters}
\alias{H2_Cullis_parameters}
\title{Calculate Cullis heritability using variance parameters}
\usage{
H2_Cullis_parameters(vd_BLUP_avg, vc_g)
}
\arguments{
\item{vd_BLUP_avg}{Numeric. Average variance of pairwise differences among BLUPs}

\item{vc_g}{Numeric. Genotype variance component}
}
\value{
Numeric value
}
\description{
Compute the Cullis heritability for genotype means using the average
variance of pairwise differences of best linear unbiased predictors (BLUPs).
}
\details{
The equation for Cullis heritability is as follow

\deqn{H^2_{Cullis} = 1 - \frac{PEV^{BLUP}_{\overline\Delta ij}}{2\sigma^2_g}}

where:
\itemize{
\item \eqn{PEV} is the prediction error variance matrix of the pairwise differences among BLUPS
\item \eqn{\sigma^2} is the variance attributed to differences between genotype
}
}
\examples{
H2_Cullis_parameters(vd_BLUP_avg = 0.25, vc_g = 0.8)

}
\references{
Cullis, B. R., Smith, A. B., & Coombes, N. E. (2006). On the design of early generation variety trials with correlated data. Journal of Agricultural, Biological, and Environmental Statistics, 11(4), 381–393. https://doi.org/10.1198/108571106X154443
}
