% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastDist.R
\name{.fastdist}
\alias{.fastdist}
\title{Calculate Genotypic Distances}
\usage{
.fastdist(GenotypeMatrix)
}
\arguments{
\item{GenotypeMatrix}{A matrix where each row represents a genotype and each column 
represents a marker. Genotypes should be coded as 0 for AA, 1 for AB, and 2 for BB, 
with 9 representing missing data.}
}
\value{
Returns a symmetric matrix of distances (canberra) between the genotypes specified in the 
`GenotypeMatrix`. Row and column names of the returned matrix correspond to the row names 
of the `GenotypeMatrix`.
}
\description{
Calculates a symmetric matrix of distances (canberra) between genotypes, based on a given genotype matrix.
Each row in the `GenotypeMatrix` represents a genotype, and each column represents a marker.
}
\examples{
# Simulate genotype data for 40 individuals across 1000 SNPs
genotypes <- .simulateHalfsib(numInd = 5, numSNP = 1000, recbound = 0:6, type = "genotype")
# Calculate the distance matrix
dist_matrix <- hsphase::.fastdist(genotypes)
print(dist_matrix)

}
