% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hstats.R
\name{plot.hstats}
\alias{plot.hstats}
\title{Plot Method for "hstats" Object}
\usage{
\method{plot}{hstats}(
  x,
  which = 1:3,
  normalize = TRUE,
  squared = TRUE,
  sort = TRUE,
  top_m = 15L,
  zero = TRUE,
  fill = getOption("hstats.fill"),
  viridis_args = getOption("hstats.viridis_args"),
  facet_scales = "free",
  ncol = 2L,
  rotate_x = FALSE,
  ...
)
}
\arguments{
\item{x}{Object of class "hstats".}

\item{which}{Which statistic(s) to be shown? Default is \code{1:3}, i.e.,
show \eqn{H^2_j} (1), \eqn{H^2_{jk}} (2), and \eqn{H^2_{jkl}} (3).}

\item{normalize}{Should statistics be normalized? Default is \code{TRUE}.}

\item{squared}{Should \emph{squared} statistics be returned? Default is \code{TRUE}.}

\item{sort}{Should results be sorted? Default is \code{TRUE}.
(Multi-output is sorted by row means.)}

\item{top_m}{How many rows should be plotted? \code{Inf} for all.}

\item{zero}{Should rows with all 0 be shown? Default is \code{TRUE}.}

\item{fill}{Fill color of ungrouped bars. The default equals the global option
\code{hstats.fill = "#fca50a"}. To change the global option, use
\verb{options(stats.fill = new value)}.}

\item{viridis_args}{List of viridis color scale arguments, see
\verb{[ggplot2::scale_color_viridis_d()]}.
The default points to the global option \code{hstats.viridis_args},
which corresponds to \code{list(begin = 0.2, end = 0.8, option = "B")}.
E.g., to switch to a standard viridis scale, you can change the default via
\code{options(hstats.viridis_args = list())}, or set \code{viridis_args = list()}.}

\item{facet_scales}{Value passed as \code{scales} argument to \verb{[ggplot2::facet_wrap()]}.}

\item{ncol}{Passed to \verb{[ggplot2::facet_wrap()]}.}

\item{rotate_x}{Should x axis labels be rotated by 45 degrees?}

\item{...}{Passed to \code{\link[ggplot2:geom_bar]{ggplot2::geom_bar()}}.}
}
\value{
An object of class "ggplot".
}
\description{
Plot method for object of class "hstats".
}
\seealso{
See \code{\link[=hstats]{hstats()}} for examples.
}
