% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fileio.optional.R
\name{.fileio.optional}
\alias{.fileio.optional}
\title{Helper function to harmonize treatment of file import results}
\usage{
.fileio.optional(
  spc,
  filename,
  ...,
  file.remove.emptyspc = hy.getOption("file.remove.emptyspc"),
  file.keep.name = hy.getOption("file.keep.name"),
  tolerance = hy.getOption("tolerance")
)
}
\arguments{
\item{spc}{hyperSpec object for file import post-processing}

\item{filename}{filename(s) to become extra data column of `spc`}

\item{...}{(ignored)}

\item{file.remove.emptyspc}{should empty (all `NA` or all `0`) spectra be
removed?}

\item{file.keep.name}{should file names be kept and put into `spc$filename`?}

\item{tolerance}{intensities in +/- `tolerance` are considered `0` for
`file.remove.emptyspc = TRUE`}
}
\value{
hyperSpec object
}
\description{
This function provides two ways of post-processing imported spectra:
}
\details{
- optionally remove empty spectra (some spectrograph software will produce
  empty spectra when measurements are cancelled)
- optionally keep the filenames in column `spc$filename`

The desired overall behavior can be set by options via [hy.setOptions()]. All
file import filters should call `.fileio.optional()` to ensure the same
behavior.
}
\keyword{internal}
