% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iglm_data.r
\name{iglm.data}
\alias{iglm.data}
\title{Constructor for the iglm.data R6 object}
\usage{
iglm.data(
  x_attribute = NULL,
  y_attribute = NULL,
  z_network = NULL,
  neighborhood = NULL,
  directed = TRUE,
  n_actor = NA,
  type_x = "binomial",
  type_y = "binomial",
  scale_x = 1,
  scale_y = 1,
  return_neighborhood = TRUE,
  file = NULL
)
}
\arguments{
\item{x_attribute}{A numeric vector for the first unit-level attribute.}

\item{y_attribute}{A numeric vector for the second unit-level attribute.}

\item{z_network}{A matrix representing the network. Can be a 2-column
edgelist or a square adjacency matrix.}

\item{neighborhood}{An optional matrix for the neighborhood representing local dependence.
Can be a 2-column edgelist or a square adjacency matrix. 
A tie in `neighborhood` between actor i and j indicates that j is in the neighborhood of i, 
implying dependence between the respective actors.}

\item{directed}{A logical value indicating if `z_network` is directed.
If `NA` (default), directedness is inferred from the symmetry of
`z_network`.}

\item{n_actor}{An integer for the number of actors in the system.
If `NA` (default), `n_actor` is inferred from the attributes or
network matrices.}

\item{type_x}{Character string for the type of `x_attribute`.
Must be one of `"binomial"`, `"poisson"`, or `"normal"`.
Default is `"binomial"`.}

\item{type_y}{Character string for the type of `y_attribute`.
Must be one of `"binomial"`, `"poisson"`, or `"normal"`.
Default is `"binomial"`.}

\item{scale_x}{A positive numeric value for scaling (e.g., variance
for "normal" type). Default is 1.}

\item{scale_y}{A positive numeric value for scaling (e.g., variance
for "normal" type). Default is 1.}

\item{return_neighborhood}{Logical. If `TRUE` (default) and
`neighborhood` is `NULL`, a full neighborhood (all dyads) is
generated implying global dependence. If `FALSE`, no neighborhood is set.}

\item{file}{(character) Optional file path to load a saved `iglm.data` object state.}
}
\value{
An object of class `iglm.data` (and `R6`).
}
\description{
Creates a `iglm.data` object, which stores network and attribute data.
This function acts as a user-friendly interface to the `iglm.data` R6 class generator.
It handles data input, infers parameters like the number of actors (`n_actor`)
and network directedness (`directed`) if not explicitly provided, processes
network data into a consistent edgelist format, calculates the overlap
relation based on an optional neighborhood definition, and performs
extensive validation of all inputs.
}
\examples{
data(state_twitter)
state_twitter$iglm.data$degree_distribution(prob = FALSE, plot = TRUE)
state_twitter$iglm.data$geodesic_distances_distribution(prob = FALSE, plot = TRUE)
state_twitter$iglm.data$density_x()
state_twitter$iglm.data$density_y()

# Generate a small iglm data object either via adjacency matrix or edgelist
tmp_adjacency <- iglm.data(z_network = matrix(c(0,1,1,0,
                                                1,0,0,1,
                                                1,0,0,1,
                                                0,1,1,0), nrow=4, byrow=TRUE),
                           directed = FALSE,
                           n_actor = 4,
                           type_x = "binomial",
                           type_y = "binomial")


tmp_edgelist <- iglm.data(z_network = tmp_adjacency$z_network, 
                          directed = FALSE,
                       n_actor = 4,
                       type_x = "binomial",
                       type_y = "binomial")

tmp_edgelist$density_z()
tmp_adjacency$density_z()
}
