% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cbs_muni.R
\name{read_cbs_muni}
\alias{read_cbs_muni}
\title{Read a municipal data file to a tibble}
\usage{
read_cbs_muni(
  path,
  year,
  muni_type = c("all", "city_lc", "rc"),
  data_domain = c("physical", "budget", "summary", "labor_force_survey", "social_survey"),
  cols = NULL,
  col_names = NULL
)
}
\arguments{
\item{path}{A character vector of length 1, denoting the local file path to the
municipal data file. A full list of available files by the CBS is at the
\href{https://www.cbs.gov.il/he/publications/Pages/2019/\%D7\%94\%D7\%A8\%D7\%A9\%D7\%95\%D7\%99\%D7\%95\%D7\%AA-\%D7\%94\%D7\%9E\%D7\%A7\%D7\%95\%D7\%9E\%D7\%99\%D7\%95\%D7\%AA-\%D7\%91\%D7\%99\%D7\%A9\%D7\%A8\%D7\%90\%D7\%9C-\%D7\%A7\%D7\%95\%D7\%91\%D7\%A6\%D7\%99-\%D7\%A0\%D7\%AA\%D7\%95\%D7\%A0\%D7\%99\%D7\%9D-\%D7\%9C\%D7\%A2\%D7\%99\%D7\%91\%D7\%95\%D7\%93-1999-2017.aspx}{relevant CBS page}.}

\item{year}{A numeric vector of length 1 denoting which year the data file
pointed in \code{path} is for. Currently supporting only 2003 and later, since before
2003 the data structure is very different.}

\item{muni_type}{A character vector of length 1, one of
\code{c("all", "city_lc", "rc")}. Since 2016, all municipal types are bundled together
in the same sheets, but before 2016 there are different sheets for cities and
local councils (\code{"city_lc"}) and regional councils (\code{"rc"}). This parameter
chooses which sheet you would read.}

\item{data_domain}{A character vector of length 1, one of
\code{c("physical", "budget", "summary", "labor_force_survey", "social_survey")}.
Every Excel municipal data file has a few different data domains, most notably
physical and population data, and budget data.}

\item{cols}{<\href{https://dplyr.tidyverse.org/reference/dplyr_tidy_select.html}{tidy-select}>
Columns to keep. The default \code{NULL} keeps all columns.}

\item{col_names}{A character vector containing the new column names of the
output tibble. If \code{NULL} then the tibble uses the original column names.
Must be the same length as the number of columns picked in \code{cols}.}
}
\value{
A tibble with municipal data for a specific year, where every row is a
municipality and every column is a different variable for this municipality in
that year. Be advised all columns are of type character, so you need to parse
the data types yourself at will. Column names are merged from the relevant headers,
and only single whitespaces are kept. Rows with more than 90\% empty cells (usually
rows with non-data notes) are removed.
}
\description{
This function is a wrapper around \code{readxl::read_excel()}, reading a specific
municipal data file for a specific year and a specific data domain. Its added
value is in its use of \code{row_to_names_fill()} and its pre-defined parameters for
every year and its specific quirks in the Excel headers. For advanced users,
the full set of options is available with \code{il.cbs.muni:::df_cbs_muni_params}.
}
\examples{
df <- read_cbs_muni(
  system.file("extdata", "p_libud_2021.xlsx", package = "il.cbs.muni"),
  year = 2021,
  data_domain = "physical"
)

df |>
  dplyr::select(1:15) |>
  dplyr::glimpse()
}
