% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_utils.R
\name{get_bbox_features}
\alias{get_bbox_features}
\title{Extract width, height, and aspect ratio from a bounding box}
\usage{
get_bbox_features(bbox)
}
\arguments{
\item{bbox}{A named numeric vector with elements \code{xmin}, \code{xmax}, \code{ymin}, \code{ymax}.}
}
\value{
A list with elements:
\item{x_range}{Width (xmax - xmin) of the bounding box}
\item{y_range}{Height (ymax - ymin) of the bounding box}
\item{xy_ratio}{Aspect ratio (x_range / y_range)}
}
\description{
Computes spatial range and aspect ratio metrics from a bounding box.
}
\examples{
# Create a sample bounding box
bbox <- c(xmin = -84, xmax = -75, ymin = 33, ymax = 37)

# Extract width, height, and aspect ratio
features <- get_bbox_features(bbox)
features

# Access individual components
features$x_range
features$y_range
features$xy_ratio

}
