% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with_inset.R
\name{ggsave_inset}
\alias{ggsave_inset}
\title{Save a composed inset plot with appropriate dimensions}
\usage{
ggsave_inset(
  filename,
  plot = last_plot(),
  device = NULL,
  path = NULL,
  scale = 1,
  width = NA,
  height = NA,
  ...,
  ratio_scale = 1,
  .cfg = last_insetcfg()
)
}
\arguments{
\item{filename}{Filename to save the plot to. Passed directly to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}.}

\item{plot}{The plot to save. Default \code{\link[ggplot2:get_last_plot]{ggplot2::last_plot()}}.}

\item{device}{Device to save to (e.g., "png", "pdf"). Default NULL (inferred from filename).}

\item{path}{Directory path for saving. Default NULL (current directory).}

\item{scale}{Scaling factor. Default 1.}

\item{width, height}{Width and height in inches. You only need to provide one; the other
will be calculated automatically. Default NA.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}.}

\item{ratio_scale}{Optional scaling factor to adjust the aspect ratio. Default 1.0. Use when
there are extra elements (e.g., titles, legends) that affect the overall image dimensions.
For example, set to 1.1 for extra width when a legend is present on the left/right side.}

\item{.cfg}{An inset configuration (class \code{insetcfg}) created by \code{\link[=config_insetmap]{config_insetmap()}}.}
}
\value{
NULL (invisibly). Saves the plot to disk.
}
\description{
A wrapper around \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}} that automatically calculates the output
dimensions based on the full ratio defined in the inset configuration.
This ensures the saved image maintains the correct aspect ratio for proper
rendering of all subplots.
}
\details{
All parameters are the same as \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}, except that you only need to
provide either \code{width} or \code{height}, and the other dimension will be calculated
automatically to match the aspect ratio defined in the inset configuration.

The function automatically calculates width and height based on \code{.cfg$main_ratio}
to maintain aspect ratio consistency. If both width and height are provided,
a warning is issued as the output aspect ratio may not match the configuration.
}
\examples{
library(sf)
library(ggplot2)

nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)

config_insetmap(
    data_list = list(nc),
    specs = list(
        inset_spec(main = TRUE),
        inset_spec(
            xmin = -84, xmax = -75, ymin = 33, ymax = 37,
            loc = "left bottom", width = 0.3
        )
    )
)

base <- ggplot(nc, aes(fill = AREA)) +
    geom_sf() +
    scale_fill_viridis_c() +
    guides(fill = "none") +
    theme_void()
with_inset(base)

# Save with automatically calculated height

ggsave_inset(paste0(tempdir(), "/inset_map.png"), width = 10)
}
\seealso{
\code{\link[=with_inset]{with_inset()}}
}
