% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregation.R
\name{orbi_get_data}
\alias{orbi_get_data}
\title{Get data frame from aggregated data}
\usage{
orbi_get_data(
  aggregated_data,
  file_info = c("filename"),
  scans = NULL,
  peaks = NULL,
  spectra = NULL,
  problems = NULL,
  summary = NULL,
  by = c("uidx", "scan.no")
)
}
\arguments{
\item{aggregated_data}{datasets aggregated from \code{\link[=orbi_aggregate_raw]{orbi_aggregate_raw()}}}

\item{file_info}{columns to get from the aggregated \code{file_info}, all \code{\link[dplyr:select]{dplyr::select()}} syntax is supported}

\item{scans}{columns to get from the aggregated \code{scans}, all \code{\link[dplyr:select]{dplyr::select()}} syntax is supported}

\item{peaks}{columns to get from the aggregated \code{peaks}, all \code{\link[dplyr:select]{dplyr::select()}} syntax is supported}

\item{spectra}{columns to get from the aggregated \code{spectra}, all \code{\link[dplyr:select]{dplyr::select()}} syntax is supported}

\item{problems}{columns to get from the aggregated \code{problems}, all \code{\link[dplyr:select]{dplyr::select()}} syntax is supported}

\item{summary}{columns to get from the \code{summary} calculated via \code{\link[=orbi_summarize_results]{orbi_summarize_results()}}, all \code{\link[dplyr:select]{dplyr::select()}} syntax is supported. Warning: it is not advisable to combine columns from \code{summary} with anything other than \code{file_info} as it will lead to duplicated datasets given that \code{summary} integrates across multiple scans.}

\item{by}{which columns to look for when joining datasets together. Make sure to include the relevant \code{by} columns in the selections of the individual datasets so they are joined correctly. The default is usually sufficient}
}
\value{
a tibble
}
\description{
Retrieve a specific subset of the aggregated data into a single data frame by specifying which columns to take from each dataset (file_info, scans, peaks, etc.) using \code{\link[dplyr:select]{dplyr::select()}} syntax. If data from more than one dataset is selected (e.g. some columns from \code{scans} AND some from \code{peaks}), the datasets are combined with an \code{\link[dplyr:mutate-joins]{dplyr::inner_join()}} using the columns listed in \code{by} (only the ones actually in the datasets). Joins that would lead to duplicated data entries (i.e. many-to-many joins) are not allowed and will throw an error to avoid unexpected replications of individual datapoints. If you really want to do such a join, you'll have to do it manually.
}
