% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iRNGStream.R
\name{i_RNGStream}
\alias{i_RNGStream}
\alias{i_RNGSubStream}
\alias{iRNGStream}
\alias{iRNGSubStream}
\title{Iterators returning distant random-number seeds.}
\usage{
i_RNGStream(seed)
}
\arguments{
\item{seed}{Either a single number to be passed to \code{set.seed} or a
vector to be passed to \code{nextRNGStream} or \code{nextRNGSubStream}.}
}
\value{
An \link{iteror} which produces seed values.

An \link{iteror} which yields successive seed values.
}
\description{
The \code{i_RNGStream} creates a sequence of random number seeds
that are very "far apart" (2^127 steps) in the overall random
number sequence, so that each can be used to make a parallel,
psudo-independent random iterator. This uses
\link[parallel:RngStream]{parallel::nextRNGStream} and the "L'Ecuyer-CMRG" generator.
}
\details{
i_RNGSubStream creates seeds that are somewhat less far apart (2^76
steps), which might be used as "substream" seeds.

Originally from the \code{itertools} package.
}
\examples{

global.seed <- .Random.seed

rng.seeds <- iRNGStream(313)
print(nextOr(rng.seeds))
print(nextOr(rng.seeds))

# create three pseudo-independent and
# reproducible random number streams
it1 <- isample(c(0, 1), 1, seed=nextOr(rng.seeds))
it2 <- isample(c(0, 1), 1, seed=nextOr(rng.seeds))
it3 <- isample(c(0, 1), 1, seed=nextOr(rng.seeds))

all(.Random.seed == global.seed)
take(it1, 5, "numeric") # 0 0 0 1 1
take(it2, 5, "numeric") # 0 1 1 1 1
take(it3, 5, "numeric") # 1 1 1 0 0

# none of this affects the global seed
all(global.seed == .Random.seed)

\donttest{
# Compute random numbers in three parallel processes with three
# well-separated seeds. Requires package "foreach"
library(foreach)
foreach(1:3, rseed=iRNGSubStream(1970), .combine='c') \%dopar\% {
  RNGkind("L'Ecuyer-CMRG") # would be better to initialize workers only once
  assign('.Random.seed', rseed, pos=.GlobalEnv)
  runif(1)
}
}
}
\references{
For more details on the L'Ecuyer-CMRG generator, see
\code{vignette("parallel", package="parallel")}.
}
\seealso{
\code{\link[base]{set.seed}},
\code{\link[parallel]{nextRNGStream}},
\code{\link[parallel]{nextRNGSubStream}}
}
