% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/i_concat.R, R/ichain.R
\name{i_concat}
\alias{i_concat}
\alias{i_chain}
\title{Iteror that chains multiple arguments together into a single iterator}
\usage{
i_concat(obj, ...)

i_chain(...)
}
\arguments{
\item{obj}{an iterable.}

\item{...}{multiple iterable arguments}
}
\value{
iteror that iterates through each argument in sequence
}
\description{
\code{i_concat(obj)} takes an iterable that returns
iterables, and chains together all inner values of iterables into
one iterator. Analogous to \code{unlist(recursive=FALSE)}.

\code{i_chain} for iterators is analogous to \code{\link[=c]{c()}} on vectors. \code{i_chain}
constructs an \link{iteror} that returns elements from the first
argument until it is exhausted, then elements from the next
argument, and so on until all arguments have been exhausted.
}
\examples{
it <- i_chain(1:3, 4:5, 6)
as.list(it)

it2 <- i_chain(1:3, levels(iris$Species))
as.list(it2)
}
\author{
Peter Meilstrup
}
