% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igrid.R
\name{i_grid}
\alias{i_grid}
\alias{igrid}
\title{Iterator that covers the Cartesian product of the arguments.}
\usage{
i_grid(
  ...,
  recycle = FALSE,
  chunkSize,
  chunks,
  simplify = FALSE,
  rowMajor = TRUE
)
}
\arguments{
\item{\dots}{Named vectors to iterate over.}

\item{recycle}{If TRUE, the iteror starts over on reaching the end.}

\item{chunkSize}{Optional; how many rows to return in each step.}

\item{chunks}{Optional; how many chunks to divide the input into.}

\item{simplify}{If TRUE, inputs are coerced to a common data type
and results are returned in a vector (or matrix if chunking is
enabled). If FALSE, results are returned as a list (or data.frame
if chunking).}

\item{rowMajor}{If TRUE, the left-most indices change fastest. If
FALSE the rightmost indices change fastest.}
}
\value{
an \link{iteror} that iterates through each element from the
Cartesian product of its arguments.
}
\description{
Given a number of vectors as arguments, constructs an iterator that enumerates the Cartesian product of all arguments.
}
\details{
Although they share the same end goal, \code{igrid} can yield
drastic memory savings compared to \code{\link[base]{expand.grid}}.
}
\examples{
# Simulate a doubly-nested loop with a single while loop
it <- igrid(a=1:3, b=1:2)
repeat {
  x <- nextOr(it, break)
  cat(sprintf('a = \%d, b = \%d\n', x$a, x$b))
}

it <- igrid(x=1:3, y=4:5)
nextOr(it, NA) # list(x=1, y=4)
nextOr(it, NA) # list(x=1, y=5)
nextOr(it, NA) # list(x=2, y=4)
nextOr(it, NA) # list(x=2, y=5)
nextOr(it, NA) # list(x=3, y=4)
nextOr(it, NA) # list(x=3, y=5)

# Second Cartesian product
nextOr(it, NA) # list(x=1, y=4)
nextOr(it, NA) # list(x=1, y=5)
nextOr(it, NA) # list(x=2, y=4)
nextOr(it, NA) # list(x=2, y=5)
nextOr(it, NA) # list(x=3, y=4)
nextOr(it, NA) # list(x=3, y=5)

# igrid is an iterator equivalent to base::expand.grid()
# Large data.frames are not created unless the iterator is manually consumed
a <- 1:2
b <- 3:4
c <- 5:6
it3 <- igrid(a=a, b=b, c=c)
df_igrid <- do.call(rbind, as.list(it3))
df_igrid <- data.frame(df_igrid)

# Compare df_igrid with the results from base::expand.grid()
base::expand.grid(a=a, b=b, c=c)
}
