% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iunique.R
\name{i_rle}
\alias{i_rle}
\alias{i_rleinv}
\title{Run-length encoding iterator.}
\usage{
i_rle(obj, cmp = identical, ...)

i_rleinv(obj, ...)
}
\arguments{
\item{obj}{An iterable}

\item{cmp}{A function to use for comparison. It should take two
arguments and return \code{TRUE} or \code{FALSE}.}

\item{...}{further arguments forwarded to \code{\link[=iteror]{iteror(obj, ...)}}.}
}
\value{
An iterator returning entries of the form \code{list(length=n, value=X)}.

\code{i_rleinv} recreates the original data from the output of \code{i_rle}.
}
\description{
This is an iterator equivalent of \link{rle}; it produces one output
value for each run if identical values in its input, along with the
lenght of the run. \code{i_rle_inverse()} performs the inverse
transformstion.
}
\examples{
it <- isample(c(TRUE, FALSE), 1, replace=TRUE)
rle <- i_rle(it)
x <- take(rle, 10)
as.logical(i_rleinv(x))
}
\seealso{
i_dedup
}
\author{
Peter Meilstrup
}
