% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iwindow.R
\name{i_window}
\alias{i_window}
\title{Construct a sliding window over an iterator}
\usage{
i_window(obj, n, tail, ...)
}
\arguments{
\item{obj}{An iterable.}

\item{n}{The width of the window to apply}

\item{tail}{If a value is given, tails will be included at
the beginning and end of iteration, filled with the given value.}

\item{...}{passed along to \code{iteror(object, ...)}}
}
\value{
an iteror.
}
\description{
Each element returned by \code{i_window(obj)} consists of \code{n} consecutive
elements from the underlying \code{obj}, with the window advancing
forward by one element each iteration.
}
\examples{

#' @examples
it <- i_window(iteror(letters[1:4]), 2)
nextOr(it, NA) # list("a", "b")
nextOr(it, NA) # list("b", "c")
nextOr(it, NA) # list("c", "d")

it2 <- i_window(icount(5), 2)
nextOr(it2, NA) # list(1, 2)
nextOr(it2, NA) # list(2, 3)
nextOr(it2, NA) # list(3, 4)
nextOr(it2, NA) # list(4, 5)

it <- i_window(letters[1:4], 2)
nextOr(it, NA) # list("a", "b")
nextOr(it, NA) # list("b", "c")
nextOr(it, NA) # list("c", "d")

it <- i_window(letters[1:4], 3)
nextOr(it) # list("a", "b", "c")
nextOr(it) # list("b", "c", "d")

it <- i_window(letters[1:4], 3, tail=" ")
nextOr(it) # list(" ", " ", "a")
nextOr(it) # list(" ", "a", "b")
nextOr(it) # list("a", "b", "c")
nextOr(it) # list("b", "c", "d")
nextOr(it) # list("c", "d", " ")
nextOr(it) # list("d", " ", " ")
}
\author{
Peter Meilstrup
}
