% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_iteror.R
\name{iteror.function}
\alias{iteror.function}
\title{Construct an iteror object with custom-programmed behavior.}
\usage{
\method{iteror}{`function`}(obj, ..., catch, sentinel, count)
}
\arguments{
\item{obj}{A function. It should have having an argument named "or"}

\item{...}{Undocumented.}

\item{catch}{If \code{obj} does not have an \code{or} argument, specify
e.g. \code{catch="StopIteration"} to interpret that an error with
that message as end of iteration.}

\item{sentinel}{If \code{obj} does not have an \code{or} argument, you can specify
a special value to watch for end of iteration. Stop will be signaled
if the function result is \code{\link[=identical]{identical()}} to \code{sentinel}.}

\item{count}{If \code{obj} does not have an \code{or} argument, you can specify
how many calls before stop iteration, or
give \code{NA} or \code{Inf} to never stop.}
}
\value{
An object of mode "function" and class "iteror".

An \link{iteror} which calls the given function to produce values.
}
\description{
Pass \code{obj} a function that has a first argument named "or".  In
writing this function, you can maintain state by using enclosed
variables and update using \verb{<<-}, Whatever value \code{obj()} returns is
the next element of the iteror. Treat argument \code{or} as a lazy value;
do not touch it until until you need to signal end of iteration;
to signal end of iteration, force and immediately return \code{or}.
}
\details{
You can also provide \code{obj} a simple function of no arguments, as
long as you specify one of \code{catch}, \code{sentinel}, or \code{count} to specify
how to detect end of iteration.
}
\examples{

# an iterator that counts from start to stop
irange <- function(from=1, to=Inf) {
  current <- from
  iteror(function(or) {
    if (current > to) {
      return(or)
    } else {
      tmp <- current
      current <<- current + 1
      tmp
    }
  })
}
it <- irange(5, 10)
as.vector(it, "numeric")

# an endless random number generator
irand <- function(min, max) {
 iteror(function() runif(1, min=min, max=max), count=Inf)
}
take(irand(5, 10), 10)
}
