% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantify.R
\name{quantify}
\alias{quantify}
\title{Count the number of times an iterable object is TRUE}
\usage{
quantify(obj, ...)
}
\arguments{
\item{obj}{an iterable object}

\item{...}{further arguments passed to \link{iteror}.}
}
\value{
the number of \code{TRUE} elements
}
\description{
Returns the number of elements from an iterable object that
evaluate to \code{TRUE}.
}
\examples{
it <- iteror(c(TRUE, FALSE, TRUE))
quantify(it) # 2

set.seed(42)
x <- sample(c(TRUE, FALSE), size=10, replace=TRUE)
quantify(x) # Equivalent to sum(x)
}
\seealso{
reduce
}
