% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irecord.R
\name{record}
\alias{record}
\alias{ireplay}
\alias{i_replay}
\title{Record and replay iterators}
\usage{
record(iterable, con, ...)
}
\arguments{
\item{iterable}{The iterable to record to the file.}

\item{con}{A file path or open connection.}

\item{...}{passed along to \code{iteror(iterable, ...)}}
}
\value{
NULL, invisibly.
}
\description{
The \code{record} function records the values issued by a specified
iterator to a file or connection object.  The \code{ireplay} function
returns an iterator that will replay those values.  This is useful for
iterating concurrently over multiple, large matrices or data frames that you
can't keep in memory at the same time.  These large objects can be recorded
to files one at a time, and then be replayed concurrently using minimal
memory.
}
\details{
Originally from the \code{itertools} package.
}
\examples{

suppressMessages(library(foreach))

m1 <- matrix(rnorm(70), 7, 10)
f1 <- tempfile()
record(iteror(m1, by='row', chunkSize=3), f1)

m2 <- matrix(1:50, 10, 5)
f2 <- tempfile()
record(iteror(m2, by='column', chunkSize=3), f2)

# Perform a simple out-of-core matrix multiply
p <- foreach(col=i_replay(f2), .combine='cbind') \%:\%
       foreach(row=i_replay(f1), .combine='rbind') \%do\% {
         row \%*\% col
       }

dimnames(p) <- NULL
print(p)
all.equal(p, m1 \%*\% m2)
unlink(c(f1, f2))

}
