% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_ancova.R
\name{s_ancova_j}
\alias{s_ancova_j}
\title{Junco Extended ANCOVA Function}
\usage{
s_ancova_j(
  df,
  .var,
  .df_row,
  variables,
  .ref_group,
  .in_ref_col,
  conf_level,
  interaction_y = FALSE,
  interaction_item = NULL,
  weights_emmeans = "counterfactual"
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{.df_row}{(\code{data.frame})\cr data set that includes all the variables that are called in \code{.var} and \code{variables}.}

\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables, with expected elements:
\itemize{
\item \code{arm} (\code{string})\cr group variable, for which the covariate adjusted means of multiple groups will be
summarized. Specifically, the first level of \code{arm} variable is taken as the reference group.
\item \code{covariates} (\code{character})\cr a vector that can contain single variable names (such as \code{"X1"}), and/or
interaction terms indicated by \code{"X1 * X2"}.
}}

\item{.ref_group}{(\code{data.frame} or \code{vector})\cr the data corresponding to the reference group.}

\item{.in_ref_col}{(\code{flag})\cr \code{TRUE} when working with the reference level, \code{FALSE} otherwise.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{interaction_y}{(\code{string} or \code{flag})\cr a selected item inside of the \code{interaction_item} variable which will be
used to select the specific ANCOVA results. if the interaction is not needed, the default option is \code{FALSE}.}

\item{interaction_item}{(\code{string} or \code{NULL})\cr name of the variable that should have interactions
with arm. if the interaction is not needed, the default option is \code{NULL}.}

\item{weights_emmeans}{(\code{string})\cr argument from \code{\link[emmeans:emmeans]{emmeans::emmeans()}}, \code{"counterfactual"} by default.}
}
\value{
Returns a named list of 8 statistics (3 extra compared to \code{tern:::s_ancova()}).
}
\description{
Extension to tern:::s_ancova, 3 extra statistics are returned:
\itemize{
\item \code{lsmean_se}: Marginal mean and estimated SE in the group.
\item \code{lsmean_ci}: Marginal mean and associated confidence interval in the group.
\item \code{lsmean_diffci}: Difference in mean and associated confidence level in one combined statistic.
In addition, the LS mean weights can be specified.
In addition, also a NULL .ref_group can be specified, the lsmean_diff related estimates will be returned as NA.
}
}
\examples{
library(dplyr)
library(tern)

df <- iris |> filter(Species == "virginica")
.df_row <- iris
.var <- "Petal.Length"
variables <- list(arm = "Species", covariates = "Sepal.Length * Sepal.Width")
.ref_group <- iris |> filter(Species == "setosa")
conf_level <- 0.95
s_ancova_j(df, .var, .df_row, variables, .ref_group, .in_ref_col = FALSE, conf_level)
}
\seealso{
Other Inclusion of ANCOVA Functions: 
\code{\link{a_summarize_ancova_j}()},
\code{\link{a_summarize_aval_chg_diff_j}()}
}
\concept{Inclusion of ANCOVA Functions}
