% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmhrms.R
\name{cmhrms}
\alias{cmhrms}
\alias{a_cmhrms_j}
\alias{s_cmhrms_j}
\alias{a_cmhrms_j_with_exclude}
\title{Cochran-Mantel-Haenszel Row Mean Scores test}
\usage{
a_cmhrms_j(
  df,
  .var,
  ref_path,
  .spl_context,
  .ref_group,
  .in_ref_col,
  .df_row,
  ...,
  variables,
  collapse_combo = TRUE,
  .stats = NULL,
  .formats = NULL,
  .indent_mods = NULL,
  .labels = NULL
)

s_cmhrms_j(
  df,
  .var,
  .ref_group,
  .in_ref_col,
  ...,
  .df_row,
  variables,
  collapse_combo = FALSE
)

a_cmhrms_j_with_exclude(
  df,
  exclude_levels,
  .var,
  .spl_context,
  .ref_group,
  .in_ref_col,
  .df_row,
  ...,
  .stats = NULL,
  .formats = NULL,
  .indent_mods = NULL,
  .labels = NULL
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{ref_path}{(\code{character})\cr global reference group specification, see \code{\link[=get_ref_info]{get_ref_info()}}.}

\item{.spl_context}{(\code{data.frame})\cr gives information about ancestor split states
that is passed by \code{rtables}.}

\item{.ref_group}{(\code{data.frame} or \code{vector})\cr the data corresponding to the reference group.}

\item{.in_ref_col}{(\code{logical})\cr \code{TRUE} when working with the reference level, \code{FALSE} otherwise.}

\item{.df_row}{(\code{data.frame})\cr data frame across all of the columns for the given row split.}

\item{...}{additional arguments for the lower level functions.}

\item{variables}{(\code{list})\cr list with arm and strata variable names.}

\item{collapse_combo}{(\code{logical})\cr If TRUE, multiple arm levels from df
will be combined into 1 level.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{'auto'} setting.}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{exclude_levels}{(\code{list})\cr A named list where names correspond to split variables
and values are vectors of levels to exclude.}
}
\value{
\itemize{
\item \code{s_cmhrms_j} a single element list containing the p-value from row mean score test.
\item \code{a_cmhrms_j} a \code{VerticalRowsSection} object (single row).
}
}
\description{
See \url{https://psiaims.github.io/CAMIS/Comp/r-sas_cmh.html} for a general comparison
overview between R and SAS.
}
\section{Functions}{
\itemize{
\item \code{a_cmhrms_j()}: Formatted analysis function which is used as \code{afun}.

\item \code{s_cmhrms_j()}: Statistics function for the calculation of the p-value
based upon the row mean scores test.

\item \code{a_cmhrms_j_with_exclude()}: Wrapper for the \code{afun} which can exclude
row split levels from producing the analysis. These have to be specified in the
\code{exclude_levels} argument, see \code{?do_exclude_split} for details.

}}
