% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ancova_rbmi.R
\name{rbmi_ancova}
\alias{rbmi_ancova}
\title{Analysis of Covariance}
\usage{
rbmi_ancova(
  data,
  vars,
  visits = NULL,
  weights = c("counterfactual", "equal", "proportional_em", "proportional")
)
}
\arguments{
\item{data}{A \code{data.frame} containing the data to be used in the model.}

\item{vars}{A \code{vars} object as generated by the set_vars() function from the rbmi package. Only the \code{group},
\code{visit}, \code{outcome} and \code{covariates} elements are required. See details.}

\item{visits}{An optional character vector specifying which visits to
fit the ancova model at. If \code{NULL}, a separate ancova model will be fit to the
outcomes for each visit (as determined by \code{unique(data[[vars$visit]])}).
See details.}

\item{weights}{Character, either \code{"counterfactual"} (default), \code{"equal"},
\code{"proportional_em"} or \code{"proportional"}.
Specifies the weighting strategy to be used when calculating the lsmeans.
See the weighting section for more details.}
}
\value{
a list of variance (\verb{var_*}), treatment effect (\verb{trt_*}), and
least square mean (\verb{lsm_*}) estimates for each visit, organized as
described in Details above.
}
\description{
Performs an analysis of covariance between two groups returning the estimated
"treatment effect" (i.e. the contrast between the two treatment groups) and
the least square means estimates in each group.
}
\details{
The function works as follows:
\enumerate{
\item Select the first value from \code{visits}.
\item Subset the data to only the observations that occurred on this visit.
\item Fit a linear model as  \code{vars$outcome ~ vars$group + vars$covariates}.
\item Extract the "treatment effect" & least square means for each treatment group.
\item Repeat points 2-3 for all other values in \code{visits}.
}

If no value for \code{visits} is provided then it will be set to
\code{unique(data[[vars$visit]])}.

In order to meet the formatting standards set by \code{\link[=rbmi_analyse]{rbmi_analyse()}} the results will be collapsed
into a single list suffixed by the visit name, e.g.:

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(
   var_visit_1 = list(est = ...),
   trt_B_visit_1 = list(est = ...),
   lsm_A_visit_1 = list(est = ...),
   lsm_B_visit_1 = list(est = ...),
   var_visit_2 = list(est = ...),
   trt_B_visit_2 = list(est = ...),
   lsm_A_visit_2 = list(est = ...),
   lsm_B_visit_2 = list(est = ...),
   ...
)
}\if{html}{\out{</div>}}

Please note that "trt" refers to the treatment effects, and "lsm" refers to the least
square mean results. In the above example \code{vars$group} has two factor levels A and B.
The new "var" refers to the model estimated variance of the residuals.

If you want to include interaction terms in your model this can be done
by providing them to the \code{covariates} argument of the set_vars() function from the rbmi package
e.g. \code{set_vars(covariates = c("sex*age"))}.
}
\note{
These functions have the \code{rbmi_} prefix to distinguish them from the corresponding
\code{rbmi} package functions, from which they were copied from. Additional features here
include:
\itemize{
\item Support for more than two treatment groups.
\item Variance estimates are returned.
}
}
\seealso{
\code{\link[=rbmi_analyse]{rbmi_analyse()}}

\code{\link[stats:lm]{stats::lm()}}

The set_vars() function from the rbmi package
}
