% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_graph_theme.R
\name{apply_graph_theme}
\alias{apply_graph_theme}
\title{Apply multiple DiagrammeR global graph attributes}
\usage{
apply_graph_theme(graph, ...)
}
\arguments{
\item{graph}{The \link[DiagrammeR:DiagrammeR]{DiagrammeR::DiagrammeR} graph to apply the attributes to.}

\item{...}{One or more character vectors of length three, where the first element is
the attribute, the second the value, and the third, the attribute type (\code{graph},
\code{node}, or \code{edge}).}
}
\value{
The \link[DiagrammeR:DiagrammeR]{DiagrammeR::DiagrammeR} graph.
}
\description{
Apply multiple DiagrammeR global graph attributes
}
\examples{
exampleJustifier <- '
---
assertion:
  -
    id: assertion_id
    label: "An assertion"
decision:
  -
    id: decision_id
    label: "A decision"
    justification:
      -
        id: justification_id
        label: "A justification"
        assertion:
          -
            id: assertion_id
            description: "A description of an assertion"
            source:
              -
                id: source1_id
                label: "First source"
              -
                id: source2_id
                label: "second source"
---
';
justifications <-
  justifier::load_justifications(text=exampleJustifier);
miniGraph_original <-
  justifications$decisionGraphs[[1]];
miniGraph <-
  justifier::apply_graph_theme(
  miniGraph_original,
  c("color", "#0000AA", "node"),
  c("shape", "triangle", "node"),
  c("fontcolor", "#FF0000", "node")
);
### This line shouldn't be run when executing this example as test,
### because rendering a DiagrammeR graph takes quite long
\dontrun{
DiagrammeR::render_graph(miniGraph);
}
}
