% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activations.R
\name{activation_glu}
\alias{activation_glu}
\title{Gated Linear Unit (GLU) activation function.}
\usage{
activation_glu(x, axis = -1L)
}
\arguments{
\item{x}{Input tensor.}

\item{axis}{The axis along which to split the input tensor. Defaults to \code{-1}.}
}
\value{
A tensor, the result from applying the activation to the input tensor \code{x}.
}
\description{
The GLU activation function is defined as:

\code{glu(x) = a * sigmoid(b)},

where \code{x} is split into two equal parts \code{a} and \code{b} along the given axis.
}
\section{Reference}{
\itemize{
\item \href{https://arxiv.org/abs/1612.08083}{Dauphin et al., 2017}
}
}

\seealso{
Other activations: \cr
\code{\link{activation_celu}()} \cr
\code{\link{activation_elu}()} \cr
\code{\link{activation_exponential}()} \cr
\code{\link{activation_gelu}()} \cr
\code{\link{activation_hard_shrink}()} \cr
\code{\link{activation_hard_sigmoid}()} \cr
\code{\link{activation_hard_tanh}()} \cr
\code{\link{activation_leaky_relu}()} \cr
\code{\link{activation_linear}()} \cr
\code{\link{activation_log_sigmoid}()} \cr
\code{\link{activation_log_softmax}()} \cr
\code{\link{activation_mish}()} \cr
\code{\link{activation_relu}()} \cr
\code{\link{activation_relu6}()} \cr
\code{\link{activation_selu}()} \cr
\code{\link{activation_sigmoid}()} \cr
\code{\link{activation_silu}()} \cr
\code{\link{activation_soft_shrink}()} \cr
\code{\link{activation_softmax}()} \cr
\code{\link{activation_softplus}()} \cr
\code{\link{activation_softsign}()} \cr
\code{\link{activation_sparse_plus}()} \cr
\code{\link{activation_sparse_sigmoid}()} \cr
\code{\link{activation_sparsemax}()} \cr
\code{\link{activation_squareplus}()} \cr
\code{\link{activation_tanh}()} \cr
\code{\link{activation_tanh_shrink}()} \cr
\code{\link{activation_threshold}()} \cr
}
\concept{activations}
