% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applications.R
\name{application_efficientnet_b3}
\alias{application_efficientnet_b3}
\title{Instantiates the EfficientNetB3 architecture.}
\usage{
application_efficientnet_b3(
  include_top = TRUE,
  weights = "imagenet",
  input_tensor = NULL,
  input_shape = NULL,
  pooling = NULL,
  classes = 1000L,
  classifier_activation = "softmax",
  name = "efficientnetb3",
  ...
)
}
\arguments{
\item{include_top}{Whether to include the fully-connected
layer at the top of the network. Defaults to \code{TRUE}.}

\item{weights}{One of \code{NULL} (random initialization),
\code{"imagenet"} (pre-training on ImageNet),
or the path to the weights file to be loaded.
Defaults to \code{"imagenet"}.}

\item{input_tensor}{Optional Keras tensor
(i.e. output of \code{keras_input()})
to use as image input for the model.}

\item{input_shape}{Optional shape tuple, only to be specified
if \code{include_top} is \code{FALSE}.
It should have exactly 3 inputs channels.}

\item{pooling}{Optional pooling mode for feature extraction
when \code{include_top} is \code{FALSE}. Defaults to \code{NULL}.
\itemize{
\item \code{NULL} means that the output of the model will be
the 4D tensor output of the
last convolutional layer.
\item \code{avg} means that global average pooling
will be applied to the output of the
last convolutional layer, and thus
the output of the model will be a 2D tensor.
\item \code{max} means that global max pooling will
be applied.
}}

\item{classes}{Optional number of classes to classify images
into, only to be specified if \code{include_top} is TRUE, and
if no \code{weights} argument is specified. 1000 is how many
ImageNet classes there are. Defaults to \code{1000}.}

\item{classifier_activation}{A \code{str} or callable. The activation function to use
on the "top" layer. Ignored unless \code{include_top=TRUE}. Set
\code{classifier_activation=NULL} to return the logits of the "top" layer.
Defaults to \code{'softmax'}.
When loading pretrained weights, \code{classifier_activation} can only
be \code{NULL} or \code{"softmax"}.}

\item{name}{The name of the model (string).}

\item{...}{For forward/backward compatability.}
}
\value{
A model instance.
}
\description{
Instantiates the EfficientNetB3 architecture.
}
\section{Reference}{
\itemize{
\item \href{https://arxiv.org/abs/1905.11946}{EfficientNet: Rethinking Model Scaling for Convolutional Neural Networks} (ICML 2019)
}

This function returns a Keras image classification model,
optionally loaded with weights pre-trained on ImageNet.

For image classification use cases, see
\href{https://keras.io/api/applications/#usage-examples-for-image-classification-models}{this page for detailed examples}.

For transfer learning use cases, make sure to read the
\href{https://keras.io/guides/transfer_learning/}{guide to transfer learning & fine-tuning}.
}

\section{Note}{
Each Keras Application expects a specific kind of input preprocessing.
For EfficientNet, input preprocessing is included as part of the model
(as a \code{Rescaling} layer), and thus
\code{\link[=application_preprocess_inputs]{application_preprocess_inputs()}} is actually a
pass-through function. EfficientNet models expect their inputs to be float
tensors of pixels with values in the \verb{[0-255]} range.
}

\seealso{
\itemize{
\item \url{https://keras.io/api/applications/efficientnet#efficientnetb3-function}
}
}
