% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{config_is_flash_attention_enabled}
\alias{config_is_flash_attention_enabled}
\title{Checks whether flash attention is globally enabled in Keras.}
\usage{
config_is_flash_attention_enabled()
}
\value{
\code{FALSE} if disabled; otherwise, it indicates that it is enabled.
}
\description{
Flash attention is a performance-optimized method for computing attention
in large models, such as transformers, allowing for faster and more
memory-efficient operations. This function checks the global Keras
configuration to determine if flash attention is enabled for compatible
layers (e.g., \code{MultiHeadAttention}).

Note that enabling flash attention does not guarantee it will always be
used. Typically, the inputs must be in \code{float16} or \code{bfloat16} dtype, and
input layout requirements may vary depending on the backend.
}
\seealso{
\code{\link[=config_disable_flash_attention]{config_disable_flash_attention()}} \code{\link[=config_enable_flash_attention]{config_enable_flash_attention()}}
}
