% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{config_max_epochs}
\alias{config_max_epochs}
\alias{config_set_max_epochs}
\alias{config_max_steps_per_epoch}
\alias{config_set_max_steps_per_epoch}
\title{Configure the default training loop limits.}
\usage{
config_max_epochs()

config_set_max_epochs(max_epochs)

config_max_steps_per_epoch()

config_set_max_steps_per_epoch(max_steps_per_epoch)
}
\arguments{
\item{max_epochs}{Integer upper bound for epochs processed by built-in training loops. Use
\code{NULL} to remove the cap.}

\item{max_steps_per_epoch}{Integer upper bound for steps processed per epoch by built-in training
loops. Use \code{NULL} to remove the cap.}
}
\value{
\code{config_max_epochs()} and \code{config_max_steps_per_epoch()} return the current
integer limits (or \code{NULL} if the cap is unset). The setter variants return
\code{NULL} invisibly and are called for side effects.
}
\description{
These helpers control the caps that built-in training loops obey when running
\code{fit()}, \code{evaluate()}, or \code{predict()}. The values can also be provided via the
\code{KERAS_MAX_EPOCHS} or \code{KERAS_MAX_STEPS_PER_EPOCH} environment variables to
quickly constrain a run without modifying source code.
}
\seealso{
Other config: \cr
\code{\link{config_backend}()} \cr
\code{\link{config_disable_flash_attention}()} \cr
\code{\link{config_disable_interactive_logging}()} \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_dtype_policy}()} \cr
\code{\link{config_enable_flash_attention}()} \cr
\code{\link{config_enable_interactive_logging}()} \cr
\code{\link{config_enable_traceback_filtering}()} \cr
\code{\link{config_enable_unsafe_deserialization}()} \cr
\code{\link{config_epsilon}()} \cr
\code{\link{config_floatx}()} \cr
\code{\link{config_image_data_format}()} \cr
\code{\link{config_is_interactive_logging_enabled}()} \cr
\code{\link{config_is_nnx_enabled}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr
\code{\link{config_set_backend}()} \cr
\code{\link{config_set_dtype_policy}()} \cr
\code{\link{config_set_epsilon}()} \cr
\code{\link{config_set_floatx}()} \cr
\code{\link{config_set_image_data_format}()} \cr
}
\concept{config}
