% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_random_binomial}
\alias{k_random_binomial}
\alias{k_random_bernoulli}
\title{Returns a tensor with random binomial distribution of values.}
\usage{
k_random_binomial(shape, p = 0, dtype = NULL, seed = NULL)

k_random_bernoulli(shape, p = 0, dtype = NULL, seed = NULL)
}
\arguments{
\item{shape}{A list of integers, the shape of tensor to create.}

\item{p}{A float, \verb{0. <= p <= 1}, probability of binomial distribution.}

\item{dtype}{String, dtype of returned tensor.}

\item{seed}{Integer, random seed.}
}
\value{
A tensor.
}
\description{
\code{k_random_binomial()} and \code{k_random_bernoulli()} are aliases for the same
function. Both are maintained for backwards compatibility. New code
should prefer \code{k_random_bernoulli()}.
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://tensorflow.rstudio.com/reference/keras/index.html#backend}.
}

