% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_pca.R
\name{kPCA_imp}
\alias{kPCA_imp}
\title{Contributions of the variables to the Principal Components ("loadings")}
\usage{
kPCA_imp(DATA, center = TRUE, projected = NULL, secure = FALSE)
}
\arguments{
\item{DATA}{A matrix or data.frame (NOT a kernel matrix) containing the data in
feature space. Please note that nrow(DATA) should be higher than ncol(DATA).
If the Linear kernel is used, this feature space is simply the original space.}

\item{center}{A logical value. If TRUE, the variables are zero-centered. (Defaults: TRUE).}

\item{projected}{(optional) If desired, the PCA projection (generated, for example, by `kPCA()`)
can be included. If DATA is big (especially in the number of rows) this may save
some computation time.}

\item{secure}{(optional) If TRUE, it tests the quality of the loadings
This may be slow. (Defaults: FALSE).}
}
\value{
A list with three objects:

* The PCA projection (class "matrix") using only the relevant Principal Components.

* The loadings.

* The values used to center each variable in Feature Space.
}
\description{
`kPCA_imp()` performs a PCA and a kernel PCA simultaneously and returns
the contributions of the variables to the Principal Components (sometimes, these
contributions are called "loadings") in Feature Space. Optionally, it can also
return the samples' projection (cropped to the relevant PCs) and the values used
to centering the variables in Feature Space.
It does not return any plot, nor it projects test data. To do so, please use `kPCA()`.
}
\details{
This function may be not valid for all kernels. Do not use it with
the RBF, Laplacian, Bray-Curtis, Jaccard/Ruzicka, or Kendall's tau kernels unless
you know exactly what you are doing.
}
\examples{
dat <- matrix(rnorm(150),ncol=30,nrow=50)
contributions <- kPCA_imp(dat)
contributions$loadings[c("PC1","PC2"),1:5]
}
