% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kuzu.R
\name{kuzu_get_all}
\alias{kuzu_get_all}
\title{Retrieve All Rows from a Query Result}
\usage{
kuzu_get_all(result)
}
\arguments{
\item{result}{A Kuzu query result object.}
}
\value{
A list where each element is a list representing a row of results.
}
\description{
Fetches all rows from a Kuzu query result and returns them as a list of
lists.
}
\examples{
\donttest{
conn <- kuzu_connection(":memory:")
kuzu_execute(conn, "CREATE NODE TABLE User(name STRING, age INT64,
PRIMARY KEY (name))")
kuzu_execute(conn, "CREATE (:User {name: 'Alice', age: 25})")
result <- kuzu_execute(conn, "MATCH (a:User) RETURN a.name, a.age")
all_results <- kuzu_get_all(result)
}
}
