% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kuzu_load_data.R
\name{kuzu_merge_df}
\alias{kuzu_merge_df}
\title{Merge Data from a Data Frame into Kuzu using a Merge Query}
\usage{
kuzu_merge_df(conn, df, merge_query)
}
\arguments{
\item{conn}{A Kuzu connection object.}

\item{df}{A \code{data.frame} or \code{tibble} containing the data to merge.}

\item{merge_query}{A string representing the Kuzu query for merging data.}
}
\value{
This function is called for its side effect of merging data and does
not return a value.
}
\description{
This function is intended for merging data from an R \code{data.frame} into Kuzu
using a specified merge query. It leverages Python's reticulate to interact
with Kuzu's Python API.
}
\examples{
\dontrun{
my_data <- data.frame(
   name = c("Alice", "Bob"),
   item = c("Book", "Pen"),
   current_city = c("New York", "London")
 )

 merge_statement <- "MERGE (p:Person {name: df.name})
 MERGE (i:Item {name: df.item})
 MERGE (p)-[:PURCHASED]->(i)
 ON MATCH SET p.current_city = df.current_city
 ON CREATE SET p.current_city = df.current_city"

 # Note: 'conn' would need to be a valid Kuzu connection object
 # and the schema (Person, Item, PURCHASED tables) would need to be created
 # before running this example.
 # kuzu_merge_df(conn, my_data, merge_statement)

 # Example with a different merge query structure:
 my_data_2 <- data.frame(
   person_name = c("Charlie"),
   purchased_item = c("Laptop"),
   city = c("Paris")
 )
#
 merge_statement_2 <- "MERGE (p:Person {name: person_name})
 MERGE (i:Item {name: purchased_item})
 MERGE (p)-[:PURCHASED]->(i)
 ON MATCH SET p.current_city = city
 ON CREATE SET p.current_city = city"

 # kuzu_merge_df(conn, my_data_2, merge_statement_2)
 }
}
\seealso{
\href{https://kuzudb.github.io/docs/import/copy-from-dataframe/}{Kuzu Copy from DataFrame}
}
