% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Math-Functions.R
\name{price_reduction}
\alias{price_reduction}
\title{Price reduction function}
\usage{
price_reduction(
  I_host,
  N_host,
  Nhost,
  Nyears,
  nTSpY,
  severity_thresh = 0.075,
  price_penalty = 0.3
)
}
\arguments{
\item{I_host}{number of infected individuals for each cultivar and timestep}

\item{N_host}{total number of individuals for each cultivar and timestep}

\item{Nhost}{total number of cultivars considered in the simulation}

\item{Nyears}{number of simulated cropping seasons}

\item{nTSpY}{number of timesteps (e.g. days) per cropping season}

\item{severity_thresh}{disease severity threshold above which the price reduction is applied}

\item{price_penalty}{percentage of price reduction}
}
\value{
A matrix with the price reduction rate per cultivar and per year of simulation
}
\description{
Give the price reduction rate associated with the infection on the (grapevine) fruits
}
\references{
Savary, S., Delbac, L., Rochas, A., Taisant, G., & Willocquet, L. (2009).
Analysis of nonlinear relationships in dual epidemics, and its application to the management
of grapevine downy and powdery mildews. Phytopathology, 99(8), 930-942.
}
