% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_methods.R
\name{vcov.lcc}
\alias{vcov.lcc}
\title{Extract Variance-Covariance Matrix of the Fixed Effects for an lcc Object}
\usage{
\method{vcov}{lcc}(object, ...)
}
\arguments{
\item{object}{An object of class \code{lcc}, representing a fitted 
longitudinal concordance correlation model.}

\item{...}{Optional arguments passed to the \code{vcov.lme}
function from the \code{nlme} package.}
}
\description{
Extracts the variance-covariance matrix of the fixed effects from a fitted
\code{lcc} model object. This function provides insights into the variability
and covariance structure of the fixed effects in the model.
}
\details{
The function specifically retrieves the variance-covariance matrix associated
with the fixed effects of the \code{lcc} object, which is useful for understanding
the relationship between these effects. For more details on variance-covariance
matrices, refer to the methods for \code{\link[nlme]{nlme}} objects.
}
\examples{
\dontrun{
fm1 <- lcc(data = hue, subject = "Fruit", resp = "H_mean",
           method = "Method", time = "Time", qf = 2, qr = 2)
vcov(fm1)
}

}
\seealso{
\code{\link{summary.lcc}}, \code{\link{lccPlot}},
  \code{\link[lcc]{lcc}}, \code{\link{coef.lcc}}
}
