% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{efficient_bfgs}
\alias{efficient_bfgs}
\title{BFGS Implementation for REML Parameter Estimation}
\usage{
efficient_bfgs(par, fn, control = list())
}
\arguments{
\item{par}{Numeric vector of initial parameter values.}

\item{fn}{Function returning list(objective, gradient). Must return both objective
value and gradient vector matching length(par).}

\item{control}{List of control parameters:
\describe{
  \item{maxit}{Maximum iterations, default 100}
  \item{abstol}{Absolute convergence tolerance, default sqrt(.Machine$double.eps)}
  \item{reltol}{Relative convergence tolerance, default sqrt(.Machine$double.eps)}
  \item{initial_damp}{Initial damping factor, default 1}
  \item{min_damp}{Minimum damping before termination, default 2^-10}
  \item{trace}{Print iteration progress, default FALSE}
}}
}
\value{
List containing:
\describe{
  \item{par}{Parameter vector minimizing objective}
  \item{value}{Minimum objective value}
  \item{counts}{Number of iterations}
  \item{convergence}{TRUE if converged within maxit}
  \item{message}{Description of termination status}
  \item{vcov}{Final approximation of inverse-Hessian, useful for inference}
}
}
\description{
BFGS optimizer designed for REML optimization of correlation parameters. Combines
function evaluation and gradient computation into single call to avoid redundant
model refitting.
}
\details{
Implements BFGS, used internally by \code{lgspline()} for optimizing correlation parameters via REML
when argument for computing gradient \code{VhalfInv_grad} is not NULL.

This is more efficient than native BFGS, since gradient and loss can be computed simultaneously,
avoiding re-computing components in "fn" and "gr" separately.
}
\examples{
\donttest{

## Minimize Rosenbrock function
fn <- function(x) {
  # Objective
  f <- 100*(x[2] - x[1]^2)^2 + (1-x[1])^2
  # Gradient
  g <- c(-400*x[1]*(x[2] - x[1]^2) - 2*(1-x[1]),
         200*(x[2] - x[1]^2))
  list(f, g)
}
(res <- efficient_bfgs(c(0.5, 2.5), fn))

## Compare to
(res0 <- stats::optim(c(0.5, 2.5), function(x)fn(x)[[1]], hessian = TRUE))
solve(res0$hessian)
}

}
\keyword{internal}
