% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{get_2ndDerivPenalty_wrapper}
\alias{get_2ndDerivPenalty_wrapper}
\title{Wrapper for Smoothing Spline Penalty Computation}
\usage{
get_2ndDerivPenalty_wrapper(
  K,
  colnm_expansions,
  C,
  power1_cols,
  power2_cols,
  power3_cols,
  power4_cols,
  interaction_single_cols,
  interaction_quad_cols,
  triplet_cols,
  nonspline_cols,
  nc,
  parallel,
  cl
)
}
\arguments{
\item{K}{Number of partitions (\eqn{K+1})}

\item{colnm_expansions}{Column names of basis expansions}

\item{C}{Basis expansion matrix of two rows, first of all maximums, second of all minimums, for all variables of interest = \code{rbind(apply(C, 2, max)), rbind(apply(C, 2, min)))} for cubic expansions "C"}

\item{power1_cols}{Linear term columns}

\item{power2_cols}{Quadratic term columns}

\item{power3_cols}{Cubic term columns}

\item{power4_cols}{Quartic term columns}

\item{interaction_single_cols}{Single interaction columns}

\item{interaction_quad_cols}{Quadratic interaction columns}

\item{triplet_cols}{Triplet interaction columns}

\item{nonspline_cols}{Predictors not treated as spline effects}

\item{nc}{Number of cubic expansions}

\item{parallel}{Logical to enable parallel processing}

\item{cl}{Cluster object for parallel computation}
}
\value{
A \eqn{p \times p} penalty matrix for smoothing spline regularization containing the
elementwise sum of the integrated squared second derivative of the fitted
function with respect to predictors of interest.

Function is exported for reference purposes - use at your own risk!
}
\description{
Computes smoothing spline penalty matrix with optional parallel processing.
Calls  \code{\link{get_2ndDerivPenalty}} after
processing spline vs. nonspline terms and preparing for parallel if desired.
}
\keyword{internal}
