% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm-out.R
\name{noise_ivf}
\alias{noise_ivf}
\alias{ivf}
\title{Noise Segmentation Algorithm}
\usage{
ivf(res = 5, n = 6)
}
\arguments{
\item{res}{numeric. Resolution of the voxels}

\item{n}{integer. The maximal number of 'other points' in the 27 voxels}
}
\description{
This function is made to be used in \link{classify_noise}. It implements an
algorithm for outliers (noise) segmentation based on isolated voxels filter (IVF).
The algorithm finds points that have only a few other points in their surrounding
3 x 3 x 3 = 27 voxels.
}
\examples{
LASfile <- system.file("extdata", "Topography.laz", package="lidR")
las <- readLAS(LASfile, filter = "-inside 273450 5274350 273550 5274450")

# Add some artificial outliers
set.seed(314)
id = round(runif(20, 0, npoints(las)))
set.seed(42)
err = runif(20, -50, 50)
las$Z[id] = las$Z[id] + err

las <- classify_noise(las, ivf(5,2))
}
\seealso{
Other noise segmentation algorithms: 
\code{\link{noise_sor}}
}
\concept{noise segmentation algorithms}
