% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-contr.R
\name{likelihood_contr_model}
\alias{likelihood_contr_model}
\title{Likelihood_contr_model}
\description{
This class encapsulates all necessary parts of a likelihood model.
A likelihood_model should provide the following methods:
\itemize{
\item \code{loglik}: computes the log-likelihood of the model
\item \code{score}: computes the score of the model
\item \code{hess_loglik}: computes the Hessian of the log-likelihood given
a data frame and parameters
}

It provides methods for computing the log-likelihood, score, and
the Hessian of log-likelihood.

It also allows for different likelihood contributions depending
on the  observation type of a row in the data frame. For example,
if the data frame contains both exact and interval-censored
observations, then the log-likelihood contributions for exact
observations and interval-censored observations are computed
separately and then summed up (assumes i.i.d. samples).
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{logliks}}{list of functions for computing log-likelihoods}

\item{\code{scores}}{list of functions for computing scores}

\item{\code{hess_logliks}}{list of functions for computing Hessians}

\item{\code{obs_type}}{function that determines observation type}

\item{\code{assumptions}}{list of assumptions made by the model}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-likelihood_contr_model-new}{\code{likelihood_contr_model$new()}}
\item \href{#method-likelihood_contr_model-loglik}{\code{likelihood_contr_model$loglik()}}
\item \href{#method-likelihood_contr_model-score}{\code{likelihood_contr_model$score()}}
\item \href{#method-likelihood_contr_model-hess_loglik}{\code{likelihood_contr_model$hess_loglik()}}
\item \href{#method-likelihood_contr_model-get_loglik}{\code{likelihood_contr_model$get_loglik()}}
\item \href{#method-likelihood_contr_model-get_score}{\code{likelihood_contr_model$get_score()}}
\item \href{#method-likelihood_contr_model-get_hess_loglik}{\code{likelihood_contr_model$get_hess_loglik()}}
\item \href{#method-likelihood_contr_model-clone}{\code{likelihood_contr_model$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-likelihood_contr_model-new"></a>}}
\if{latex}{\out{\hypertarget{method-likelihood_contr_model-new}{}}}
\subsection{Method \code{new()}}{
Initializes a new instance of the class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{likelihood_contr_model$new(
  obs_type,
  logliks = NULL,
  scores = NULL,
  hess_logliks = NULL,
  assumptions = c("iid")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{obs_type}}{function that determines observation type}

\item{\code{logliks}}{list of functions for computing log-likelihoods
If an observation type does not have a log-likelihood dispatcher
specified here, then we lazily construct a log-likelihood for said
observation type by looking for a \code{loglik.type}, where \code{type} is the
observation type. If we cannot find a \code{loglik.type}, then we throw
an error.}

\item{\code{scores}}{list of functions for computing scores.
If an observation type does not have a score dispatcher specified
here, then we lazily construct a score for said observation
type using the following method:
(1) first, we look for a \code{score.type}, where \code{type} is the
observation type.
(2) if (1) fails, then we use a finite difference method given the
log-likelihood contribution for the observation type.}

\item{\code{hess_logliks}}{list of functions for computing Hessians of the
log-likelihood given the observed data. If an observation type does
not have a Hessian dispatcher specified here, then we lazily
construct a Hessian for said observation type using the following
method:
(1) first, we look for a \code{hess_loglik.type}, where \code{type} is the
observation type.
(2) if (1) fails, then we use a finite difference method given the
log-likelihood contribution for the observation type.}

\item{\code{assumptions}}{list of assumptions made by the model, default is
c("iid""), which assumes iid observations (this assumption is always
made for this class, which is why we can sum the log-likelihood
contributions)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{likelihood_contr_model} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-likelihood_contr_model-loglik"></a>}}
\if{latex}{\out{\hypertarget{method-likelihood_contr_model-loglik}{}}}
\subsection{Method \code{loglik()}}{
Computes the log-likelihood of the model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{likelihood_contr_model$loglik(df, par, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{df}}{dataframe for computation}

\item{\code{par}}{parameters for computation}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The total log-likelihood
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-likelihood_contr_model-score"></a>}}
\if{latex}{\out{\hypertarget{method-likelihood_contr_model-score}{}}}
\subsection{Method \code{score()}}{
Computes the score of the model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{likelihood_contr_model$score(df, par, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{df}}{dataframe for computation}

\item{\code{par}}{parameters for computation}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The total score
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-likelihood_contr_model-hess_loglik"></a>}}
\if{latex}{\out{\hypertarget{method-likelihood_contr_model-hess_loglik}{}}}
\subsection{Method \code{hess_loglik()}}{
Computes the Hessian of the log-likelihood.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{likelihood_contr_model$hess_loglik(df, par, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{df}}{dataframe for computation}

\item{\code{par}}{parameters for computation}

\item{\code{...}}{additional arguments}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The Hessian of the log-likelihood
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-likelihood_contr_model-get_loglik"></a>}}
\if{latex}{\out{\hypertarget{method-likelihood_contr_model-get_loglik}{}}}
\subsection{Method \code{get_loglik()}}{
Gets the loglikelihood contribution for an observation of \code{type}.

If the loglikelihood contribution for \code{type} does not have a
corresponding method in the dispatcher, then we try to retrieve one
from \code{loglik.type}, where \code{type} is the observation type. If this
fails, then we throw an error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{likelihood_contr_model$get_loglik(type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{observation type}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The loglikelihood contribution for an observation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-likelihood_contr_model-get_score"></a>}}
\if{latex}{\out{\hypertarget{method-likelihood_contr_model-get_score}{}}}
\subsection{Method \code{get_score()}}{
Gets the score for an observation of \code{type}.

If the score for \code{type} does not have a corresponding method in the
dispatcher, then we try to retrieve one from \code{score.type}, where
\code{type} is the observation type. If this fails, then we use a
finite difference method to compute the gradient of the
log-likelihood function for the observation type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{likelihood_contr_model$get_score(type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{observation type}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The score for an observation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-likelihood_contr_model-get_hess_loglik"></a>}}
\if{latex}{\out{\hypertarget{method-likelihood_contr_model-get_hess_loglik}{}}}
\subsection{Method \code{get_hess_loglik()}}{
Gets the Hessian of the log-likelihood for an observation of \code{type}.

If the Hessian of the log-likelihood for \code{type} does not have a
corresponding method in the dispatcher, then we try to retrieve one
from \code{hess_loglik.type}, where \code{type} is the observation type. If
this fails, then we use a finite difference method to compute the
Hessian of the log-likelihood function for the observation type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{likelihood_contr_model$get_hess_loglik(type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{observation type}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The Hessian of the log-likelihood for an observation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-likelihood_contr_model-clone"></a>}}
\if{latex}{\out{\hypertarget{method-likelihood_contr_model-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{likelihood_contr_model$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
