% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/site.R
\name{fuse_book}
\alias{fuse_book}
\title{Fuse multiple R Markdown documents to a single output file}
\usage{
fuse_book(input = ".", output = NULL, envir = parent.frame())
}
\arguments{
\item{input}{A directory or a vector of file paths. By default, all
\code{.Rmd}/\code{.md} files under the current working directory are used as the
input, except for filenames that start with \code{.} or \verb{_} (e.g., \verb{_foo.Rmd}),
or \code{.md} files with the same base names as \code{.Rmd} files (e.g., \code{bar.md}
will not be used if \code{bar.Rmd} exists). For a directory \code{input}, the file
search will be recursive if \code{input} ends with a slash (i.e.,
sub-directories will also be searched). If a file named \code{index.Rmd} or
\code{index.md} exists, it will always be treated as the first input file. Input
files can also be specified in the config file \verb{_litedown.yml} (in the
\code{input} field under \code{book}).}

\item{output}{An output file path or a filename extension (e.g., \code{.html},
\code{.tex}, \code{.xml}, \code{.man}, \code{.markdown}, or \code{.txt}). In the latter case, the
output file path will use the extension on the same base filename as the
input file if the \code{input} is a file. If \code{output} is not character (e.g.,
\code{NA}), the results will be returned as a character vector instead of being
written to a file. If \code{output} is \code{NULL} or an extension, and the input is
a file path, the output file path will have the same base name as the input
file, with an extension corresponding to the output format. The output
format is retrieved from the first value in the \code{output} field of the YAML
metadata of the \code{input} (e.g., \code{html} will generate HTML output). The
\code{output} argument can also take an output format name (possible values are
\code{html}, \code{latex}, \code{xml}, \code{man}, \code{commonmark}, and \code{text}). If no output
format is detected or provided, the default is HTML.}

\item{envir}{An environment in which the code is to be evaluated. It can be
accessed via \code{\link[=fuse_env]{fuse_env()}} inside \code{\link[=fuse]{fuse()}}.}
}
\value{
An output file path or the output content, depending on the \code{output}
argument.
}
\description{
This is a helper function to \code{\link[=fuse]{fuse()}} \code{.Rmd} files and convert all their
Markdown output to a single output file, which is similar to
\code{bookdown::render_book()}, but one major differences is that all HTML output
is written to one file, instead of one HTML file per chapter.
}
\details{
If the output format needs to be customized, the settings should be written
in the config file \verb{_litedown.yml}, e.g.,

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{---
output:
  html:
    options:
      toc:
        depth: 4
  latex:
    meta:
      documentclass: "book"
}\if{html}{\out{</div>}}

In addition, you can configure the book via the \code{book} field, e.g.,

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{---
book:
  new_session: true
  subdir: false
  pattern: "[.]R?md$"
  chapter_before: "Information before a chapter."
  chapter_after: "This chapter was generated from `$input$`."
---
}\if{html}{\out{</div>}}

The option \code{new_session} specifies whether to render each input file in the
current R session or a separate new R session; \code{chapter_before} and
\code{chapter_after} specify text to be added to the beginning and end of each
file, respectively, which accepts some variables (e.g., \verb{$input$} is the
current input file path).
}
