#' @importFrom utils capture.output head tail str packageVersion
#' @importFrom stats na.omit
NULL

.onAttach <- function(libname, pkgname) {
  msg <- paste0(
    "llmflow ", utils::packageVersion("llmflow"), "\n",
    "For LLM communication, please load ellmer: library(ellmer)"
  )
  packageStartupMessage(msg)
}

#' Get or Create Evaluation Environment
#'
#' Creates and manages an isolated evaluation environment for code execution
#' within callr sessions. This environment has base R as its parent, allowing
#' access to all standard R functions while keeping user objects isolated.
#'
#' @return An environment for code evaluation
#' @noRd
get_llmflow_env <- function() {
  env_name <- ".llmflow_eval_env"
  if (!exists(env_name, envir = baseenv(), inherits = FALSE)) {
    # Create new environment with base environment parent
    # This gives access to all base R functions
    eval_env <- new.env(parent = baseenv())
    assign(env_name, eval_env, envir = baseenv())
  }
  get(env_name, envir = baseenv(), inherits = FALSE)
}

#' Initialize Evaluation Environment in callr Session
#'
#' Creates the evaluation environment code string to be run inside callr sessions.
#' Returns R code that sets up the isolated environment.
#'
#' @return Character string of R code to initialize the environment
#' @noRd
init_eval_env_code <- function() {
  '
  if (!exists(".llmflow_eval_env", envir = baseenv(), inherits = FALSE)) {
    .llmflow_eval_env <- new.env(parent = baseenv())
    assign(".llmflow_eval_env", .llmflow_eval_env, envir = baseenv())
  }
  get(".llmflow_eval_env", envir = baseenv(), inherits = FALSE)
  '
}
