% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepseek_processor.R
\name{DeepSeekProcessor}
\alias{DeepSeekProcessor}
\title{DeepSeek API Processor}
\description{
DeepSeek API Processor

DeepSeek API Processor
}
\details{
Concrete implementation of BaseAPIProcessor for DeepSeek models.
Handles DeepSeek-specific API calls, authentication, and response parsing.
}
\section{Super class}{
\code{\link[mLLMCelltype:BaseAPIProcessor]{mLLMCelltype::BaseAPIProcessor}} -> \code{DeepSeekProcessor}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DeepSeekProcessor-new}{\code{DeepSeekProcessor$new()}}
\item \href{#method-DeepSeekProcessor-get_default_api_url}{\code{DeepSeekProcessor$get_default_api_url()}}
\item \href{#method-DeepSeekProcessor-make_api_call}{\code{DeepSeekProcessor$make_api_call()}}
\item \href{#method-DeepSeekProcessor-extract_response_content}{\code{DeepSeekProcessor$extract_response_content()}}
\item \href{#method-DeepSeekProcessor-clone}{\code{DeepSeekProcessor$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mLLMCelltype" data-topic="BaseAPIProcessor" data-id="get_api_url"><a href='../../mLLMCelltype/html/BaseAPIProcessor.html#method-BaseAPIProcessor-get_api_url'><code>mLLMCelltype::BaseAPIProcessor$get_api_url()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mLLMCelltype" data-topic="BaseAPIProcessor" data-id="process_request"><a href='../../mLLMCelltype/html/BaseAPIProcessor.html#method-BaseAPIProcessor-process_request'><code>mLLMCelltype::BaseAPIProcessor$process_request()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DeepSeekProcessor-new"></a>}}
\if{latex}{\out{\hypertarget{method-DeepSeekProcessor-new}{}}}
\subsection{Method \code{new()}}{
Initialize DeepSeek processor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DeepSeekProcessor$new(base_url = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DeepSeekProcessor-get_default_api_url"></a>}}
\if{latex}{\out{\hypertarget{method-DeepSeekProcessor-get_default_api_url}{}}}
\subsection{Method \code{get_default_api_url()}}{
Get default DeepSeek API URL
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DeepSeekProcessor$get_default_api_url()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DeepSeekProcessor-make_api_call"></a>}}
\if{latex}{\out{\hypertarget{method-DeepSeekProcessor-make_api_call}{}}}
\subsection{Method \code{make_api_call()}}{
Make API call to DeepSeek
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DeepSeekProcessor$make_api_call(chunk_content, model, api_key)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DeepSeekProcessor-extract_response_content"></a>}}
\if{latex}{\out{\hypertarget{method-DeepSeekProcessor-extract_response_content}{}}}
\subsection{Method \code{extract_response_content()}}{
Extract response content from DeepSeek API response
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DeepSeekProcessor$extract_response_content(response, model)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DeepSeekProcessor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DeepSeekProcessor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DeepSeekProcessor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
