% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_closure.R
\name{measure_closure}
\alias{measure_closure}
\alias{net_reciprocity}
\alias{node_reciprocity}
\alias{net_transitivity}
\alias{node_transitivity}
\alias{net_equivalency}
\alias{node_equivalency}
\alias{net_congruency}
\title{Measures of network closure}
\usage{
net_reciprocity(.data, method = "default")

node_reciprocity(.data)

net_transitivity(.data)

node_transitivity(.data)

net_equivalency(.data)

node_equivalency(.data)

net_congruency(.data, object2)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{method}{For reciprocity, either \code{default} or \code{ratio}.
See \code{?igraph::reciprocity}}

\item{object2}{Optionally, a second (two-mode) matrix, igraph, or tidygraph}
}
\description{
These functions offer methods for summarising the closure in configurations
in one-, two-, and three-mode networks:
\itemize{
\item \code{net_reciprocity()} measures reciprocity in a (usually directed) network.
\item \code{node_reciprocity()} measures nodes' reciprocity.
\item \code{net_transitivity()} measures transitivity in a network.
\item \code{node_transitivity()} measures nodes' transitivity.
\item \code{net_equivalency()} measures equivalence or reinforcement
in a (usually two-mode) network.
\item \code{net_congruency()} measures congruency across two two-mode networks.
}
}
\details{
For one-mode networks, shallow wrappers of igraph versions exist via
\code{net_reciprocity} and \code{net_transitivity}.

For two-mode networks, \code{net_equivalency} calculates the proportion of three-paths in the network
that are closed by fourth tie to establish a "shared four-cycle" structure.

For three-mode networks, \code{net_congruency} calculates the proportion of three-paths
spanning two two-mode networks that are closed by a fourth tie to establish a
"congruent four-cycle" structure.
}
\section{Equivalency}{

The \code{net_equivalency()} function calculates the Robins and Alexander (2004)
clustering coefficient for two-mode networks.
Note that for weighted two-mode networks, the result is divided by the average tie weight.
}

\examples{
net_reciprocity(ison_southern_women)
node_reciprocity(to_unweighted(ison_networkers))
net_transitivity(ison_adolescents)
node_transitivity(ison_adolescents)
net_equivalency(ison_southern_women)
node_equivalency(ison_southern_women)
}
\references{
\subsection{On equivalency or four-cycles}{

Robins, Garry L, and Malcolm Alexander. 2004.
Small worlds among interlocking directors: Network structure and distance in bipartite graphs.
\emph{Computational & Mathematical Organization Theory} 10(1): 69–94.
\doi{10.1023/B:CMOT.0000032580.12184.c0}.
}

\subsection{On congruency}{

Knoke, David, Mario Diani, James Hollway, and Dimitris C Christopoulos. 2021.
\emph{Multimodal Political Networks}.
Cambridge University Press. Cambridge University Press.
\doi{10.1017/9781108985000}
}
}
\seealso{
Other measures: 
\code{\link{measure_attributes_nodes}},
\code{\link{measure_attributes_ties}},
\code{\link{measure_central_between}},
\code{\link{measure_central_close}},
\code{\link{measure_central_degree}},
\code{\link{measure_central_eigen}},
\code{\link{measure_cohesion}},
\code{\link{measure_diffusion_infection}},
\code{\link{measure_diffusion_net}},
\code{\link{measure_diffusion_node}},
\code{\link{measure_features}},
\code{\link{measure_heterogeneity}},
\code{\link{measure_hierarchy}},
\code{\link{measure_holes}},
\code{\link{measure_periods}},
\code{\link{measure_properties}},
\code{\link{member_diffusion}}
}
\concept{measures}
