% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F22.R
\name{F22}
\alias{F22}
\title{Shekel 7 Function (F22)}
\usage{
F22(x)
}
\arguments{
\item{x}{Numeric vector of length 4 (4-dimensional input).}
}
\value{
Numeric scalar representing the function value.
}
\description{
A multimodal test function from the Shekel family with 7 local minima.
Fixed dimension of 4.
}
\details{
\strong{Formula:}
\deqn{f(x) = -\sum_{i=1}^{7} \frac{1}{(x - a_i)^T(x - a_i) + c_i}}

where \eqn{a_i} are 4-dimensional vectors and \eqn{c_i} are scalars.

\strong{Global minimum:} \eqn{f(4, 4, 4, 4) \approx -10.4029}

\strong{Characteristics:}
\itemize{
  \item Type: Multimodal
  \item Separable: No
  \item Differentiable: Yes
  \item Fixed dimension: 4
  \item Number of local minima: 7
  \item Default bounds: \eqn{[0, 10]^4}
}

The Shekel 7 function has more local minima than Shekel 5, making it
slightly more challenging.
}
\examples{
F22(c(4, 4, 4, 4))  # Returns approximately -10.40 (near global minimum)
F22(c(0, 0, 0, 0))  # Returns a value close to 0

}
\seealso{
\code{\link{test-functions}} for an overview of all test functions,
\code{\link{get_function_details}} to retrieve function parameters,
\code{\link{F21}} for Shekel 5, \code{\link{F23}} for Shekel 10.
}
